/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.script.complex;

import com.github.kancyframework.validationplus.script.AbstractScriptBindHandler;
import com.github.kancyframework.validationplus.script.aviator.AviatorScriptBindHandler;
import com.github.kancyframework.validationplus.script.complex.ComplexScriptEngine;
import com.github.kancyframework.validationplus.script.ql.QLExpressScriptBindHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.script.ScriptEngine;

public class ComplexScriptBindHandler
extends AbstractScriptBindHandler {
    private final List<AbstractScriptBindHandler> scriptBindHandlers = new ArrayList<AbstractScriptBindHandler>();

    public ComplexScriptBindHandler() {
        this.scriptBindHandlers.add(new QLExpressScriptBindHandler());
        this.scriptBindHandlers.add(new AviatorScriptBindHandler());
    }

    @Override
    public List<String> getVariableNames(ScriptEngine engine, String script, boolean cache) {
        HashSet<String> allVariableNames = new HashSet<String>();
        ComplexScriptEngine complexScriptEngine = this.getComplexScriptEngine(engine);
        for (AbstractScriptBindHandler scriptBindHandler : this.scriptBindHandlers) {
            ScriptEngine scriptEngine = complexScriptEngine.findScriptEngine(scriptBindHandler.lang());
            List<String> variableNames = null;
            try {
                variableNames = scriptBindHandler.getVariableNames(scriptEngine, script, cache);
                allVariableNames.addAll(variableNames);
            }
            catch (Exception exception) {}
        }
        return new ArrayList<String>(allVariableNames);
    }

    private ComplexScriptEngine getComplexScriptEngine(ScriptEngine engine) {
        return (ComplexScriptEngine)engine;
    }

    @Override
    public String lang() {
        return "complex";
    }
}

