/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.script.complex;

import com.github.kancyframework.validationplus.script.complex.ComplexScriptEngineFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ComplexScriptEngine
extends AbstractScriptEngine {
    private Map<String, ScriptEngine> scriptEngineCache = new ConcurrentHashMap<String, ScriptEngine>();
    private Map<String, ScriptEngine> scriptEngineMap = new HashMap<String, ScriptEngine>();
    private List<ScriptEngine> scriptEngines = new ArrayList<ScriptEngine>();
    private final ComplexScriptEngineFactory factory;

    public ComplexScriptEngine(ComplexScriptEngineFactory factory) {
        this.factory = factory;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory engineFactory : engineFactories) {
            if (Objects.equals(engineFactory.getClass(), factory.getClass())) continue;
            ScriptEngine scriptEngine = engineFactory.getScriptEngine();
            this.scriptEngines.add(scriptEngine);
            engineFactory.getNames().forEach(engineName -> this.scriptEngineMap.put((String)engineName, scriptEngine));
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        String cacheKey = this.getScriptEngineCacheKey(script, context);
        if (this.scriptEngineCache.containsKey(cacheKey)) {
            ScriptEngine scriptEngine = this.scriptEngineCache.get(cacheKey);
            return scriptEngine.eval(script, context);
        }
        Exception exception = null;
        for (ScriptEngine scriptEngine : this.scriptEngines) {
            try {
                Object result = scriptEngine.eval(script, context);
                System.err.println(script + "\uff0c" + result + "\uff0c" + scriptEngine.getClass().getName());
                this.scriptEngineCache.put(cacheKey, scriptEngine);
                return result;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (Objects.nonNull(exception)) {
            throw new ScriptException(exception);
        }
        return null;
    }

    private String getScriptEngineCacheKey(String script, ScriptContext context) {
        Object aThis = context.getAttribute("this");
        if (Objects.nonNull(aThis)) {
            return script + aThis.getClass().getName();
        }
        return script;
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Exception exception = null;
        for (ScriptEngine scriptEngine : this.scriptEngines) {
            try {
                return scriptEngine.eval(reader, context);
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (Objects.nonNull(exception)) {
            throw new ScriptException(exception);
        }
        return null;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public ScriptEngine findScriptEngine(String lang) {
        return this.scriptEngineMap.get(lang);
    }
}

