/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.script.ql;

import com.github.kancyframework.validationplus.script.AbstractScriptBindHandler;
import com.github.kancyframework.validationplus.script.ql.QLExpressScriptEngine;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngine;

public class QLExpressScriptBindHandler
extends AbstractScriptBindHandler {
    private Map<String, List<String>> outVarNameMap = new HashMap<String, List<String>>();

    @Override
    public List<String> getVariableNames(ScriptEngine engine, String script, boolean cache) {
        if (cache) {
            List<String> outVarNames = this.outVarNameMap.get(script);
            if (Objects.isNull(outVarNames)) {
                outVarNames = this.parseVariableNames(engine, script);
                this.outVarNameMap.put(script, outVarNames);
            }
            return outVarNames;
        }
        return this.parseVariableNames(engine, script);
    }

    private List<String> parseVariableNames(ScriptEngine engine, String script) {
        try {
            QLExpressScriptEngine qlExpressScriptEngine = this.getQLExpressScriptEngine(engine);
            String[] outVarNames = qlExpressScriptEngine.getRunner().getOutVarNames(script);
            return Arrays.asList(outVarNames);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    private QLExpressScriptEngine getQLExpressScriptEngine(ScriptEngine engine) {
        return (QLExpressScriptEngine)engine;
    }

    @Override
    public String lang() {
        return "ql";
    }
}

