/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import java.util.Collection;
import java.util.Objects;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.ScriptCheck;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import org.hibernate.validator.internal.constraintvalidators.hv.AbstractScriptAssertValidator;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;

public class ScriptCheckValidator
extends AbstractScriptAssertValidator<ScriptCheck, Object> {
    private String reportOn;
    private String message;
    private boolean required;

    public void initialize(ConstraintDescriptor<ScriptCheck> constraintDescriptor, HibernateConstraintValidatorInitializationContext initializationContext) {
        ScriptCheck constraintAnnotation = (ScriptCheck)constraintDescriptor.getAnnotation();
        this.validateParameters(constraintAnnotation);
        this.initialize(constraintAnnotation.lang(), constraintAnnotation.script(), initializationContext);
        this.reportOn = constraintAnnotation.reportOn();
        this.message = constraintAnnotation.message();
        this.required = constraintAnnotation.required();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        boolean validationResult;
        if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("script", (Object)this.escapedScript);
        }
        if (this.required) {
            if (Objects.isNull(value)) {
                return false;
            }
            if (value instanceof String && Objects.equals(String.valueOf(value).trim(), "")) {
                return false;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                return false;
            }
        }
        if (!(validationResult = this.scriptAssertContext.evaluateScriptAssertExpression(value, "$")) && !this.reportOn.isEmpty()) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(this.message).addPropertyNode(this.reportOn).addConstraintViolation();
        }
        return validationResult;
    }

    private void validateParameters(ScriptCheck constraintAnnotation) {
        Contracts.assertNotEmpty((String)constraintAnnotation.script(), (String)Messages.MESSAGES.parameterMustNotBeEmpty("script"));
        Contracts.assertNotEmpty((String)constraintAnnotation.lang(), (String)Messages.MESSAGES.parameterMustNotBeEmpty("lang"));
    }
}

