/*
 * Decompiled with CFR 0.152.
 */
package com.github.karamelsoft.testing.data.driven.testing.database.operations;

import com.github.karamelsoft.testing.data.driven.testing.database.builders.DataSourceBuilder;
import com.github.karamelsoft.testing.data.driven.testing.database.builders.SQLBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class Execute
implements Runnable {
    private final DataSource dataSource;
    private final Collection<String> orders;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Execute copy) {
        Builder builder = new Builder();
        builder.dataSource = copy.dataSource;
        builder.orders = new ArrayList<String>(copy.orders);
        return builder;
    }

    private Execute(Builder builder) {
        this.dataSource = builder.dataSource;
        this.orders = builder.orders;
    }

    @Override
    public void run() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.orders.forEach(jdbcTemplate::execute);
    }

    public static class Builder
    implements DataSourceBuilder<SQLBuilder<Builder>>,
    SQLBuilder<Builder> {
        private DataSource dataSource;
        private Collection<String> orders = new ArrayList<String>();

        private Builder() {
        }

        @Override
        public SQLBuilder<Builder> dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public Builder order(String order) {
            this.orders.add(order);
            return this;
        }

        public Execute build() {
            return new Execute(this);
        }
    }
}

