/*
 * Decompiled with CFR 0.152.
 */
package com.github.karamelsoft.testing.data.driven.testing.database.operations;

import com.github.karamelsoft.testing.data.driven.testing.api.Tester;
import com.github.karamelsoft.testing.data.driven.testing.api.operations.Save;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class Export<T>
implements Consumer<Tester<T>> {
    private final DataSource dataSource;
    private final String query;
    private final String fileName;
    private final Save<Object> save;

    private Export(Builder builder) {
        this.dataSource = builder.dataSource;
        this.query = builder.query;
        this.fileName = builder.fileName;
        this.save = builder.save;
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    public static <T> Builder<T> newBuilder(Export<T> copy) {
        Builder builder = new Builder();
        builder.dataSource = copy.dataSource;
        builder.query = copy.query;
        builder.fileName = copy.fileName;
        builder.save = copy.save;
        return builder;
    }

    @Override
    public void accept(Tester<T> tTester) {
        tTester.value(new JdbcTemplate(this.dataSource).queryForList(this.query)).save(this.fileName, this.save);
    }

    public static final class Builder<T> {
        private DataSource dataSource;
        private String query;
        private String fileName;
        private Save<Object> save;

        private Builder() {
        }

        public Builder<T> dataSource(DataSource val) {
            this.dataSource = val;
            return this;
        }

        public Builder<T> query(String val) {
            this.query = val;
            return this;
        }

        public Builder<T> fileName(String val) {
            this.fileName = val;
            return this;
        }

        public Builder<T> save(Save<Object> val) {
            this.save = val;
            return this;
        }

        public Export<T> build() {
            return new Export(this);
        }
    }
}

