/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldHaveEqualContent;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class InputStreams {
    private static final InputStreams INSTANCE = new InputStreams();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static InputStreams instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    InputStreams() {
    }

    public void assertEqualContent(AssertionInfo info, InputStream actual, InputStream expected) {
        if (expected == null) {
            throw new NullPointerException("The InputStream to compare to should not be null");
        }
        InputStreams.assertNotNull(info, actual);
        try {
            List<String> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveEqualContent.shouldHaveEqualContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of InputStreams:%n  <%s>%nand:%n  <%s>", actual, expected);
            throw new InputStreamsException(msg, e);
        }
    }

    private static void assertNotNull(AssertionInfo info, InputStream stream) {
        Objects.instance().assertNotNull(info, stream);
    }
}

