/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class Integers
extends Numbers<Integer> {
    private static final Integers INSTANCE = new Integers();

    public static Integers instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Integers() {
    }

    public Integers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Integer zero() {
        return 0;
    }

    public void assertIsCloseTo(AssertionInfo info, Integer actual, Integer expected, Offset<Integer> offset) {
        Integers.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        int absDiff = Math.abs(expected - actual);
        if (absDiff > (Integer)offset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, absDiff));
        }
    }
}

