/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class NumberGrouping {
    private static final String UNDERSCORE_SEPARATOR = "_";
    private static Pattern hexGroupPattern = Pattern.compile("([0-9|A-Z]{4})");
    private static Pattern binaryGroupPattern = Pattern.compile("([0-1]{8})");

    static String toHexLiteral(String value) {
        if (value.length() > 4) {
            return NumberGrouping.toHexLiteral(hexGroupPattern, value);
        }
        return value;
    }

    static String toBinaryLiteral(String value) {
        return NumberGrouping.toHexLiteral(binaryGroupPattern, value);
    }

    private static String toHexLiteral(Pattern pattern, String value) {
        Matcher matcher = pattern.matcher(value);
        StringBuilder literalBuilder = new StringBuilder();
        while (matcher.find()) {
            String byteGroup = matcher.group(1);
            if (NumberGrouping.notEmpty(literalBuilder)) {
                literalBuilder.append(UNDERSCORE_SEPARATOR);
            }
            literalBuilder.append(byteGroup);
        }
        return literalBuilder.toString();
    }

    private static boolean notEmpty(StringBuilder sb) {
        return sb.length() != 0;
    }

    private NumberGrouping() {
    }
}

