/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayjam.executor.executors;

import com.github.kayjam.executor.exceptions.KayJamRuntimeException;
import com.github.kayjamlang.core.Expression;
import com.github.kayjamlang.core.expressions.OperationExpression;
import com.github.kayjamlang.core.provider.Context;
import com.github.kayjamlang.core.provider.ExpressionProvider;
import com.github.kayjamlang.core.provider.MainExpressionProvider;
import java.util.Objects;

public class OperationExpressionExecutor
extends ExpressionProvider<OperationExpression, Object> {
    public Object provide(MainExpressionProvider<Object> mainProvider, Context context, Context argsContext, OperationExpression expression) throws Exception {
        if (expression.operation != null) {
            Object left = mainProvider.provide(expression.left, context, argsContext);
            Object right = mainProvider.provide(expression.right, context, argsContext);
            switch (expression.operation) {
                case PLUS: {
                    if (left instanceof String || right instanceof String) {
                        return left.toString() + right.toString();
                    }
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() + ((Number)right).longValue();
                }
                case MINUS: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() - ((Number)right).longValue();
                }
                case DIVISION: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() / ((Number)right).longValue();
                }
                case MULTIPLY: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() * ((Number)right).longValue();
                }
                case LESS_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() < ((Number)right).longValue();
                }
                case LESS_EQUALS_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() <= ((Number)right).longValue();
                }
                case GREATER_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() > ((Number)right).longValue();
                }
                case GREATER_EQUALS_SIGN: {
                    if (!(left instanceof Number) || !(right instanceof Number)) break;
                    return ((Number)left).longValue() >= ((Number)right).longValue();
                }
                case EQUALS: {
                    return Objects.equals(left, right);
                }
                case NOT_EQUALS: {
                    return !Objects.equals(left, right);
                }
                case OR: {
                    if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                    return (Boolean)left != false || (Boolean)right != false;
                }
                case AND: {
                    if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                    return (Boolean)left != false && (Boolean)right != false;
                }
            }
        } else {
            throw new KayJamRuntimeException((Expression)expression, "This operation in executor not released");
        }
        throw new KayJamRuntimeException((Expression)expression, "Invalid operation values");
    }
}

