/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.runtime.RuntimeContext;
import java.util.Objects;

public class ConstNode
extends Node {
    private final Object value;

    public ConstNode(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public static String inspectValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return String.format("'%s'", value);
        }
        return value.toString();
    }

    @Override
    public Object evaluate(RuntimeContext context) {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConstNode && Objects.equals(this.value, ((ConstNode)obj).value);
    }

    @Override
    public String inspect() {
        return ConstNode.inspectValue(this.value);
    }
}

