/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.runtime.RuntimeContext;
import java.util.regex.Pattern;

public class RegexNode
extends Node {
    private final Pattern pattern;

    public RegexNode(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public String inspect() {
        return String.format("/%s/", this.pattern.toString());
    }

    private boolean matches(String actual) {
        return AssertionFailure.assertRegexMatches(this.pattern, actual, this.getPositionBegin());
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContext context) {
        Object actual = actualNode.evaluate(context);
        if (actual instanceof String) {
            return this.matches((String)actual);
        }
        throw new RuntimeException("Operator = before regex need a string input value", operator.getPosition());
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContext context) {
        return this.matches((String)context.getConverter().convert(String.class, actualNode.evaluate(context)));
    }

    public boolean equals(Object o) {
        return o instanceof RegexNode && ((RegexNode)o).pattern.toString().equals(this.pattern.toString());
    }
}

