/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.ast.SchemaWhichExpression;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.RuntimeContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaExpression
extends Node {
    private final Node instance;
    private final List<SchemaNode> schemaNodes = new ArrayList<SchemaNode>();
    private final ObjectRef objectRef = new ObjectRef();

    public SchemaExpression(Node previous, List<SchemaNode> schemaNodes) {
        this.instance = previous;
        this.schemaNodes.addAll(schemaNodes);
    }

    public Object getTypeInstance() {
        return this.objectRef.instance;
    }

    public String getSchemaName() {
        return this.schemaNodes.get(0).getSchema();
    }

    @Override
    public Object evaluate(RuntimeContext context) {
        try {
            return this.matches(context, this.objectRef);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), this.getPositionBegin());
        }
    }

    private boolean matches(RuntimeContext context, ObjectRef objectRef) {
        return this.schemaNodes.stream().allMatch(schemaNode -> this.verifyAndConvertAsSchemaType(context, (SchemaNode)schemaNode, objectRef));
    }

    private boolean verifyAndConvertAsSchemaType(RuntimeContext context, SchemaNode schemaNode, ObjectRef objectRef) {
        try {
            objectRef.instance = schemaNode.getConstructorViaSchema(context).apply(this.instance.evaluateDataObject(context));
            return true;
        }
        catch (IllegalTypeException exception) {
            throw new AssertionFailure(exception.assertionFailureMessage(schemaNode), schemaNode.getPositionBegin());
        }
    }

    @Override
    public String inspect() {
        String instanceInspect = this.instance instanceof InputNode ? "" : this.instance.inspect() + " ";
        return String.format("%sis %s", instanceInspect, this.schemaNodes.stream().map(SchemaNode::inspect).collect(Collectors.joining(String.format(" %s ", "/"))));
    }

    public SchemaWhichExpression which(Node whichClause, boolean omitWhich) {
        return (SchemaWhichExpression)new SchemaWhichExpression(this, whichClause, omitWhich).setPositionBegin(this.getPositionBegin());
    }

    public SchemaWhichExpression omitWhich(Node n) {
        return this.which(n, true);
    }

    public SchemaWhichExpression which(Node n) {
        return this.which(n, false);
    }

    static class ObjectRef {
        public Object instance;

        ObjectRef() {
        }
    }
}

