/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.compiler.ExpressionMatcher;
import com.github.leeonky.dal.compiler.TokenParser;
import java.util.Optional;
import java.util.function.Function;

public interface NodeFactory {
    public Node fetch(TokenParser var1);

    default public NodeFactory recursive(ExpressionMatcher expressionMatcher) {
        return parser -> {
            Node node = this.fetch(parser);
            Optional<Node> optionalNode = expressionMatcher.fetch(parser, node);
            while (optionalNode.isPresent()) {
                node = optionalNode.get();
                optionalNode = expressionMatcher.fetch(parser, node);
            }
            return node;
        };
    }

    default public NodeFactory map(Function<Node, Node> mapping) {
        return parser -> (Node)mapping.apply(this.fetch(parser));
    }
}

