/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.compiler.Token;
import com.github.leeonky.dal.compiler.TokenMatcher;
import com.github.leeonky.dal.compiler.TokenParser;
import com.github.leeonky.dal.runtime.IfThenFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class SourceCode {
    private final String code;
    private final char[] chars;
    private int position = 0;

    public static TokenMatcher tokenMatcher(Predicate<Character> startsWith, Collection<String> excluded, boolean trim, Set<Character> delimiters, Predicate<Token> validator) {
        return SourceCode.tokenMatcher(startsWith, excluded, trim, (Character c1, Character c2) -> delimiters.contains(c2), validator);
    }

    public static TokenMatcher tokenMatcher(Predicate<Character> startsWith, Collection<String> excluded, boolean trim, BiPredicate<Character, Character> endsWith, Predicate<Token> validator) {
        return sourceCode -> {
            if (sourceCode.whenFirstChar(startsWith) && sourceCode.isEndOfCode()) {
                if (excluded.stream().noneMatch(sourceCode::startsWith)) {
                    Token token = new Token(sourceCode.position);
                    if (trim) {
                        sourceCode.popChar();
                        sourceCode.leftTrim();
                    }
                    if (sourceCode.isEndOfCode()) {
                        do {
                            token.append(sourceCode.popChar());
                        } while (sourceCode.isEndOfCode() && !endsWith.test(Character.valueOf(token.lastChar()), Character.valueOf(sourceCode.currentChar())));
                    }
                    if (validator.test(token)) {
                        return Optional.of(token);
                    }
                    sourceCode.position = token.getPosition();
                }
            }
            return Optional.empty();
        };
    }

    public SourceCode(String code) {
        this.code = code;
        this.chars = code.toCharArray();
    }

    private int seek(int seek) {
        int position = this.position;
        this.position += seek;
        return position;
    }

    private char currentChar() {
        return this.chars[this.position];
    }

    private char popChar() {
        return this.chars[this.position++];
    }

    private boolean whenFirstChar(Predicate<Character> predicate) {
        return this.leftTrim().isEndOfCode() && predicate.test(Character.valueOf(this.currentChar()));
    }

    public boolean isEndOfCode() {
        return this.position < this.chars.length;
    }

    public SourceCode leftTrim() {
        while (this.isEndOfCode() && Character.isWhitespace(this.currentChar())) {
            ++this.position;
        }
        return this;
    }

    public boolean startsWith(String word) {
        this.leftTrim();
        return this.code.startsWith(word, this.position);
    }

    public char escapedPop(Map<String, Character> escapeChars) {
        return escapeChars.entrySet().stream().filter(e -> this.code.startsWith((String)e.getKey(), this.position)).map(e -> {
            this.seek(((String)e.getKey()).length());
            return (Character)e.getValue();
        }).findFirst().orElseGet(this::popChar).charValue();
    }

    public boolean isBeginning() {
        return IntStream.range(0, this.position).mapToObj(i -> Character.valueOf(this.chars[i])).allMatch(Character::isWhitespace);
    }

    public SyntaxException syntaxError(String message, int positionOffset) {
        return new SyntaxException(message, this.position + positionOffset);
    }

    public Optional<Token> popWord(String word) {
        return this.popWord(word, () -> true);
    }

    public Optional<Token> popWord(String word, Supplier<Boolean> predicate) {
        return IfThenFactory.when(this.startsWith(word) && predicate.get() != false).optional(() -> new Token(this.seek(word.length())).append(word));
    }

    public <T> Optional<Node> fetchElements(TokenParser.FetchBy fetchBy, Character opening, char closing, Function<Integer, T> element, Function<List<T>, Node> nodeFactory) {
        return IfThenFactory.when(this.whenFirstChar(opening::equals)).optional(() -> {
            int startPosition = this.seek(1);
            ArrayList elements = new ArrayList();
            int index = 0;
            while (this.isEndOfCode() && closing != this.currentChar()) {
                elements.add(element.apply(index++));
                fetchBy.afterFetchElement(this);
            }
            if (!this.isEndOfCode()) {
                throw this.syntaxError(String.format("should end with `%c`", Character.valueOf(closing)), 0);
            }
            this.seek(1);
            return ((Node)nodeFactory.apply(elements)).setPositionBegin(startPosition);
        });
    }
}

