/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.IfThenFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Token {
    private final StringBuilder contentBuilder;
    private final int position;

    public int getPosition() {
        return this.position;
    }

    public Token(int position) {
        this.position = position;
        this.contentBuilder = new StringBuilder();
    }

    public Number getInteger() {
        String content = this.getContent();
        return FunctionUtil.getValue(() -> Integer.decode(content), () -> Long.decode(content), () -> this.decodeBigInteger(content), () -> (Number)FunctionUtil.oneOf(() -> this.parseNumber(content, "y", Byte::decode), () -> this.parseNumber(content, "s", Short::decode), () -> this.parseNumber(content, "l", Long::decode), () -> this.parseNumber(content, "bi", this::decodeBigInteger)).orElseThrow(() -> new SyntaxException("expect an integer", this.position)));
    }

    private BigInteger decodeBigInteger(String str) {
        Matcher matcher = Pattern.compile("0[xX](.*)").matcher(str);
        if (matcher.matches()) {
            return new BigInteger(matcher.group(1), 16);
        }
        return new BigInteger(str);
    }

    public Number getNumber() {
        String content = this.getContent();
        return FunctionUtil.getValue(this::getInteger, () -> FunctionUtil.oneOf(() -> this.parseNumber(content, "f", Float::valueOf), () -> this.parseNumber(content, "bd", BigDecimal::new), () -> this.parseNumber(content, "d", Double::valueOf)).orElseGet(() -> {
            double value = Double.parseDouble(content);
            if (Double.isInfinite(value)) {
                return new BigDecimal(content);
            }
            return value;
        }));
    }

    private <T extends Number> Optional<T> parseNumber(String content, String postfix, Function<String, T> factory) {
        Pattern pattern = Pattern.compile(String.format("([^_]*)(%s|%s)$", postfix, postfix.toUpperCase()));
        Matcher matcher = pattern.matcher(content);
        return IfThenFactory.when(matcher.matches()).optional(() -> (Number)factory.apply(matcher.group(1)));
    }

    public String getContent() {
        return this.contentBuilder.toString();
    }

    public void append(char c) {
        this.contentBuilder.append(c);
    }

    public char lastChar() {
        return this.contentBuilder.charAt(this.contentBuilder.length() - 1);
    }

    public Token append(String str) {
        this.contentBuilder.append(str);
        return this;
    }

    public Node toDotProperty(Node instanceNode) {
        if (this.contentBuilder.length() == 0) {
            throw new SyntaxException("property is not finished", this.position);
        }
        return new PropertyNode(instanceNode, this.getContent(), PropertyNode.Type.DOT);
    }

    public boolean isNumber() {
        try {
            return this.getNumber() != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public boolean all() {
        return true;
    }
}

