/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.runtime.ClassKeyMap;
import com.github.leeonky.dal.runtime.ConstructorViaSchema;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.ListAccessor;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.NoSuchAccessorException;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RuntimeContext {
    private final LinkedList<DataObject> thisStack = new LinkedList();
    private final ClassKeyMap<PropertyAccessor<Object>> propertyAccessors;
    private final ClassKeyMap<ListAccessor<Object>> listAccessors;
    private final Map<String, ConstructorViaSchema> constructors;
    private final Set<Class<?>> schemas;
    private final Map<String, BeanClass<?>> schemaMap;
    private final Converter converter = Converter.createDefault();
    private boolean listMapping = false;

    public RuntimeContext(Object inputValue, ClassKeyMap<PropertyAccessor<?>> propertyAccessors, Map<String, ConstructorViaSchema> constructors, ClassKeyMap<ListAccessor<?>> listAccessors, Map<String, BeanClass<?>> schemas) {
        this.schemas = schemas.values().stream().map(BeanClass::getType).collect(Collectors.toSet());
        this.schemaMap = schemas;
        this.constructors = constructors;
        this.propertyAccessors = propertyAccessors;
        this.listAccessors = listAccessors;
        this.thisStack.push(this.wrap(inputValue));
    }

    public DataObject getInputValue() {
        return this.thisStack.getFirst();
    }

    public Object wrapInputValueAndEvaluate(Object value, Node node, String schema) {
        return this.newThisScope(new DataObject(value, this, SchemaType.create(this.schemaMap.get(schema))), () -> node.evaluate(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T newThisScope(DataObject dataObject, Supplier<T> supplier) {
        try {
            this.thisStack.push(dataObject);
            T t = supplier.get();
            return t;
        }
        finally {
            this.thisStack.pop();
        }
    }

    public Optional<ConstructorViaSchema> searchConstructor(String type) {
        return Optional.ofNullable(this.constructors.get(type));
    }

    public boolean isSchemaRegistered(Class<?> fieldType) {
        return this.schemas.contains(fieldType);
    }

    public Set<String> findPropertyReaderNames(Object instance) {
        return this.propertyAccessors.getData(instance).getPropertyNames(instance);
    }

    public Boolean isNull(Object instance) {
        return this.propertyAccessors.tryGetData(instance).map(f -> f.isNull(instance)).orElseGet(() -> Objects.equals(instance, null));
    }

    public Object getPropertyValue(Object instance, String name) {
        return this.propertyAccessors.getData(instance).getValue(instance, name);
    }

    public Iterable<Object> getList(Object instance) {
        return this.listAccessors.tryGetData(instance).map(l -> l.toIterable(instance)).orElseGet(() -> this.arrayIterable(instance));
    }

    private Iterable<Object> arrayIterable(final Object instance) {
        return () -> new Iterator<Object>(){
            private final int length;
            private int index;
            {
                this.length = Array.getLength(instance);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.length;
            }

            @Override
            public Object next() {
                return Array.get(instance, this.index++);
            }
        };
    }

    public boolean isRegisteredList(Object instance) {
        return this.listAccessors.containsType(instance);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public DataObject wrap(Object instance) {
        return new DataObject(instance, this, SchemaType.createRoot());
    }

    public RuntimeContext registerPropertyAccessor(final Object instance) {
        if (!Objects.equals(instance, null) && !this.propertyAccessors.containsType(instance)) {
            this.propertyAccessors.put(BeanClass.getClass((Object)instance), new PropertyAccessor<Object>(){
                private final BeanClass<Object> beanClass;
                {
                    this.beanClass = BeanClass.createFrom((Object)instance);
                }

                @Override
                public Object getValue(Object instance1, String name) {
                    try {
                        return this.beanClass.getPropertyValue(instance1, name);
                    }
                    catch (NoSuchAccessorException ignore) {
                        try {
                            return this.beanClass.getType().getMethod(name, new Class[0]).invoke(instance1, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }

                @Override
                public Set<String> getPropertyNames(Object instance1) {
                    return this.beanClass.getPropertyReaders().keySet();
                }

                @Override
                public boolean isNull(Object instance1) {
                    return Objects.equals(instance1, null);
                }
            });
        }
        return this;
    }

    public void beginListMapping() {
        this.listMapping = true;
    }

    public boolean isListMapping() {
        return this.listMapping;
    }

    public void endListMapping() {
        this.listMapping = false;
    }
}

