/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Formatters;
import com.github.leeonky.dal.runtime.ClassKeyMap;
import com.github.leeonky.dal.runtime.ConstructorViaSchema;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.ListAccessor;
import com.github.leeonky.dal.runtime.NameStrategy;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.RuntimeContext;
import com.github.leeonky.util.BeanClass;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class RuntimeContextBuilder {
    private final ClassKeyMap<PropertyAccessor<?>> propertyAccessors = new ClassKeyMap();
    private final ClassKeyMap<ListAccessor<?>> listAccessors = new ClassKeyMap();
    private final Map<String, ConstructorViaSchema> constructors = new LinkedHashMap<String, ConstructorViaSchema>();
    private final Map<String, BeanClass<?>> schemas = new HashMap();

    public RuntimeContextBuilder() {
        this.registerValueFormat(new Formatters.String()).registerValueFormat(new Formatters.URL()).registerValueFormat(new Formatters.Instant()).registerValueFormat(new Formatters.LocalDate()).registerValueFormat(new Formatters.LocalDateTime()).registerValueFormat(new Formatters.Enum()).registerValueFormat(new Formatters.Number()).registerValueFormat(new Formatters.PositiveInteger()).registerValueFormat(new Formatters.Integer()).registerValueFormat(new Formatters.PositiveNumber()).registerValueFormat(new Formatters.ZeroNumber()).registerValueFormat(new Formatters.Boolean()).registerSchema("List", DataObject::isList).registerListAccessor(Iterable.class, iterable -> iterable).registerListAccessor(Stream.class, stream -> stream::iterator).registerPropertyAccessor(Map.class, new PropertyAccessor<Map<String, ?>>(){

            @Override
            public Object getValue(Map<String, ?> instance, String name) {
                return instance.get(name);
            }

            @Override
            public Set<String> getPropertyNames(Map<String, ?> instance) {
                return instance.keySet();
            }

            @Override
            public boolean isNull(Map<String, ?> instance) {
                return instance == null;
            }
        });
    }

    public RuntimeContext build(Object inputValue) {
        return new RuntimeContext(inputValue, this.propertyAccessors, this.constructors, this.listAccessors, this.schemas);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter<?, ?> formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter<?, ?> formatter) {
        this.constructors.put(name, o -> formatter.transform(o.getInstance()));
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<?> schema) {
        return this.registerSchema(NameStrategy.SIMPLE_NAME, schema);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<?> schema) {
        this.schemas.put(name, BeanClass.create(schema));
        return this.registerSchema(name, (DataObject dataObject) -> dataObject.createSchemaVerifier().verify(schema, null, ""));
    }

    public RuntimeContextBuilder registerSchema(String name, Function<DataObject, Boolean> predicate) {
        this.constructors.put(name, o -> {
            if (((Boolean)predicate.apply((DataObject)o)).booleanValue()) {
                return o.getInstance();
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<? extends T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T> RuntimeContextBuilder registerListAccessor(Class<T> type, ListAccessor<? extends T> listAccessor) {
        this.listAccessors.put(type, listAccessor);
        return this;
    }

    public RuntimeContextBuilder registerSchema(NameStrategy nameStrategy, Class<?> schema) {
        return this.registerSchema(nameStrategy.toName(schema), schema);
    }
}

