/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.BeanWrapper;
import com.github.leeonky.dal.CompilingContext;
import com.github.leeonky.dal.RuntimeException;
import com.github.leeonky.dal.ast.Node;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class PropertyNode
extends Node {
    private final Node instanceNode;
    private final List<String> properties;

    public PropertyNode(Node instanceNode, List<String> properties) {
        this.instanceNode = instanceNode;
        this.properties = properties;
    }

    @Override
    public Object evaluate(CompilingContext context) {
        Object instance = this.instanceNode.evaluate(context);
        for (String name : this.properties) {
            instance = this.getPropertyValue(instance, name, context);
        }
        return instance;
    }

    private Object getPropertyValue(Object instance, String name, CompilingContext context) {
        if ("size".equals(name) && context.isList(instance)) {
            return this.getListSize(instance, context);
        }
        try {
            return new BeanWrapper(instance, context.getPropertyAccessors()).getPropertyValue(name);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("Get property " + name + " failed, property can be public field, getter or customer type getter", this.getPositionBegin());
        }
    }

    private Object getListSize(Object instance, CompilingContext context) {
        return context.searchListAccessor(instance).map(p -> p.size(instance)).orElseGet(() -> {
            if (instance instanceof Iterable) {
                Iterator iterator = ((Iterable)instance).iterator();
                int size = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                    ++size;
                }
                return size;
            }
            return Array.getLength(instance);
        });
    }

    public boolean equals(Object obj) {
        return obj instanceof PropertyNode && Objects.equals(this.instanceNode, ((PropertyNode)obj).instanceNode) && Objects.equals(this.properties, ((PropertyNode)obj).properties);
    }
}

