/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.SyntaxException;
import com.github.leeonky.dal.ast.BracketNode;
import com.github.leeonky.dal.token.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TokenStream {
    private static final Set<String> UNARY_OPERATORS_WITHOUT_INTENTION = new HashSet<String>(Arrays.asList("!"));
    private static final Set<String> UNARY_OPERATORS = new HashSet<String>(Arrays.asList("-")){
        {
            this.addAll(UNARY_OPERATORS_WITHOUT_INTENTION);
        }
    };
    private final List<Token> tokens = new ArrayList<Token>();
    private int index = 0;

    public Token pop() {
        return this.tokens.get(this.index++);
    }

    public boolean hasTokens() {
        return this.index < this.tokens.size();
    }

    public List<Token> allTokens() {
        return new ArrayList<Token>(this.tokens);
    }

    public void appendToken(Token token) {
        this.tokens.add(token);
    }

    public Token.Type currentType() {
        return this.tokens.get(this.index).getType();
    }

    public boolean isCurrentSingleEvaluateNode() {
        return this.currentType() == Token.Type.PROPERTY || this.currentType() == Token.Type.CONST_INDEX;
    }

    public int getPosition() {
        return this.hasTokens() ? this.tokens.get(this.index).getPositionBegin() : (this.index > 0 ? this.tokens.get(this.index - 1).getPositionEnd() : 0);
    }

    public boolean isCurrentKeywordAndTake(String keyword) {
        Token token = this.tokens.get(this.index);
        if (token.getType() == Token.Type.KEY_WORD && keyword.equals(token.getValue())) {
            ++this.index;
            return true;
        }
        return false;
    }

    public boolean isCurrentBeginBracket() {
        return this.currentType() == Token.Type.BEGIN_BRACKET;
    }

    public boolean isCurrentEndBracketAndTakeThenFinishBracket(BracketNode bracketNode) {
        if (this.currentType() == Token.Type.END_BRACKET) {
            if (bracketNode == null) {
                throw new SyntaxException(this.index, "missed begin bracket");
            }
            bracketNode.finishBracket();
            ++this.index;
            return true;
        }
        return false;
    }

    public boolean isSingleUnaryOperator(boolean withoutIntention) {
        return this.currentType() == Token.Type.OPERATOR && (withoutIntention ? UNARY_OPERATORS_WITHOUT_INTENTION : UNARY_OPERATORS).contains(this.tokens.get(this.index).getValue());
    }
}

