/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.SyntaxException;
import com.github.leeonky.dal.token.SourceCode;
import com.github.leeonky.dal.token.Token;
import com.github.leeonky.dal.token.TokenCandidate;

class DoubleQuotationStringTokenCandidate
extends TokenCandidate {
    private boolean isEscape = false;
    private int codeLength = 0;

    DoubleQuotationStringTokenCandidate(SourceCode sourceCode) {
        super(sourceCode);
    }

    @Override
    protected Token toToken() {
        if (!this.isFinished()) {
            throw new SyntaxException(this.getStartPosition() + this.codeLength + 1, "string should end with '\"'");
        }
        return Token.constValueToken(this.content());
    }

    @Override
    protected boolean append(char c) {
        ++this.codeLength;
        if (this.isEscape) {
            super.append(this.getEscapedChar(c));
            this.isEscape = false;
        } else {
            if (c == '\\') {
                this.isEscape = true;
                return true;
            }
            super.append(c);
        }
        return false;
    }

    private char getEscapedChar(char c) {
        switch (c) {
            case '\"': {
                return '\"';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case '\\': {
                return '\\';
            }
        }
        throw new SyntaxException(this.getStartPosition() + this.codeLength, "unsupported escape char");
    }

    @Override
    protected boolean isDiscardBeginChar() {
        return true;
    }

    @Override
    protected String discardedSuffix() {
        return "\"";
    }

    @Override
    protected boolean isUnexpectedChar(char c) {
        return false;
    }
}

