/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.SyntaxException;
import com.github.leeonky.dal.ast.Operator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Token {
    private final Type type;
    private final Object value;
    private int positionBegin;
    private int positionEnd;

    public Token(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public static Token wordToken(Object value) {
        return new Token(Type.WORD, value);
    }

    public static Token propertyToken(String ... properties) {
        return new Token(Type.PROPERTY, Arrays.asList(properties));
    }

    public static Token constIndexToken(int value) {
        return new Token(Type.CONST_INDEX, value);
    }

    public static Token operatorToken(String value) {
        return new Token(Type.OPERATOR, value);
    }

    public static Token constValueToken(Object value) {
        return new Token(Type.CONST_VALUE, value);
    }

    public static Token beginBracketToken() {
        return new Token(Type.BEGIN_BRACKET, "(");
    }

    public static Token endBracketToken() {
        return new Token(Type.END_BRACKET, ")");
    }

    public static Token keyWordToken(String keyWord) {
        return new Token(Type.KEY_WORD, keyWord);
    }

    public boolean equals(Object obj) {
        return obj instanceof Token && Objects.equals((Object)this.type, (Object)((Token)obj).type) && Objects.equals(this.value, ((Token)obj).value);
    }

    public String toString() {
        return (Object)((Object)this.type) + "`" + this.value + "`";
    }

    public Object getValue() {
        return this.value;
    }

    public List<String> getProperties() {
        return (List)this.value;
    }

    public Type getType() {
        return this.type;
    }

    public int getPositionEnd() {
        return this.positionEnd;
    }

    public void setPositionEnd(int positionEnd) {
        this.positionEnd = positionEnd;
    }

    public int getPositionBegin() {
        return this.positionBegin;
    }

    public void setPositionBegin(int positionBegin) {
        this.positionBegin = positionBegin;
    }

    public Operator toOperator(boolean isUnaryOperator) {
        Operator operator;
        String operatorString = this.value.toString();
        if (isUnaryOperator) {
            switch (operatorString) {
                case "-": {
                    operator = new Operator.Minus();
                    break;
                }
                case "!": {
                    operator = new Operator.Not();
                    break;
                }
                default: {
                    throw new SyntaxException(this.getPositionBegin(), "not support operator " + operatorString + " yet");
                }
            }
        } else {
            switch (operatorString) {
                case "=": {
                    operator = new Operator.Equal();
                    break;
                }
                case ">": {
                    operator = new Operator.Greater();
                    break;
                }
                case "<": {
                    operator = new Operator.Less();
                    break;
                }
                case ">=": {
                    operator = new Operator.GreaterOrEqual();
                    break;
                }
                case "<=": {
                    operator = new Operator.LessOrEqual();
                    break;
                }
                case "!=": {
                    operator = new Operator.NotEqual();
                    break;
                }
                case "+": {
                    operator = new Operator.Plus();
                    break;
                }
                case "-": {
                    operator = new Operator.Subtraction();
                    break;
                }
                case "*": {
                    operator = new Operator.Multiplication();
                    break;
                }
                case "/": {
                    operator = new Operator.Division();
                    break;
                }
                case "&&": {
                    operator = new Operator.And();
                    break;
                }
                case "||": {
                    operator = new Operator.Or();
                    break;
                }
                default: {
                    throw new SyntaxException(this.getPositionBegin(), "not support operator " + operatorString + " yet");
                }
            }
        }
        operator.setPosition(this.getPositionBegin());
        return operator;
    }

    public static enum Type {
        WORD,
        PROPERTY,
        CONST_INDEX,
        OPERATOR,
        BEGIN_BRACKET,
        END_BRACKET,
        KEY_WORD,
        CONST_VALUE;

    }
}

