/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.token.Scanner;
import com.github.leeonky.dal.token.SourceCode;
import com.github.leeonky.dal.token.Token;
import com.github.leeonky.dal.token.TokenCandidate;

class WordTokenCandidate
extends TokenCandidate {
    WordTokenCandidate(SourceCode sourceCode) {
        super(sourceCode, Scanner.CHAR_SPLIT);
    }

    @Override
    protected Token toToken() {
        String content = this.content();
        if ("null".equals(content)) {
            return Token.constValueToken(null);
        }
        if ("true".equals(content)) {
            return Token.constValueToken(true);
        }
        if ("false".equals(content)) {
            return Token.constValueToken(false);
        }
        if ("and".equals(content)) {
            return Token.operatorToken("&&");
        }
        if ("or".equals(content)) {
            return Token.operatorToken("||");
        }
        if (Scanner.KEYWORD_SETS.contains(content)) {
            return Token.keyWordToken(content);
        }
        return Token.wordToken(content);
    }
}

