/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.Constructor;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.dal.util.TypeData;
import com.github.leeonky.dal.util.WrappedObject;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RuntimeContext {
    private final TypeData<PropertyAccessor> propertyAccessors;
    private final TypeData<ListAccessor> listAccessors;
    private final LinkedList<Object> wrappedValueStack = new LinkedList();
    private final Map<String, Constructor> constructors;
    private final Set<Class<?>> schemas;

    public RuntimeContext(Object inputValue, TypeData<PropertyAccessor> propertyAccessors, Map<String, Constructor> constructors, TypeData<ListAccessor> listAccessors, Set<Class<?>> schemas) {
        this.schemas = schemas;
        this.wrappedValueStack.push(inputValue);
        this.constructors = constructors;
        this.propertyAccessors = propertyAccessors;
        this.listAccessors = listAccessors;
    }

    public Object getInputValue() {
        return this.wrappedValueStack.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object wrapInputValueAndEvaluate(Object value, Node node) {
        try {
            this.wrappedValueStack.push(value);
            Object object = node.evaluate(this);
            return object;
        }
        finally {
            this.wrappedValueStack.pop();
        }
    }

    public Optional<Constructor> searchConstructor(String type) {
        return Optional.ofNullable(this.constructors.get(type));
    }

    public Optional<ListAccessor> searchListAccessor(Object object) {
        return this.listAccessors.getData(object);
    }

    public WrappedObject wrap(Object instance) {
        return new WrappedObject(instance, this);
    }

    public boolean isRegistered(Class<?> fieldType) {
        return this.schemas.contains(fieldType);
    }

    public Optional<Set> findPropertyReaderNames(Object instance) {
        return this.propertyAccessors.getData(instance).map(f -> f.getPropertyNames(instance));
    }

    public Boolean isNull(Object instance) {
        return this.propertyAccessors.getData(instance).map(p -> p.isNull(instance)).orElseGet(() -> Objects.equals(instance, null));
    }

    public Optional<Object> getPropertyValue(Object instance, String name) {
        return this.propertyAccessors.getData(instance).map(p -> p.getValue(instance, name));
    }

    public Optional<Iterable> gitList(Object instance) {
        return this.listAccessors.getData(instance).map(l -> l.toIterable(instance));
    }

    public boolean isRegisteredList(Object instance) {
        return this.listAccessors.containsType(instance);
    }
}

