/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

import com.github.leeonky.dal.SyntaxException;
import com.github.leeonky.dal.token.SourceCode;
import com.github.leeonky.dal.token.Token;
import com.github.leeonky.dal.token.TokenCandidate;

class SingleQuotationStringTokenCandidate
extends TokenCandidate {
    SingleQuotationStringTokenCandidate(SourceCode sourceCode) {
        super(sourceCode);
    }

    @Override
    protected Token toToken() {
        if (!this.isFinished()) {
            throw new SyntaxException(this.getStartPosition() + this.content().length() + 1, "string should end with '''");
        }
        return Token.constValueToken(this.content());
    }

    @Override
    protected boolean isDiscardBeginChar() {
        return true;
    }

    @Override
    protected String discardedSuffix() {
        return "'";
    }

    @Override
    protected boolean isUnexpectedChar(char c) {
        return false;
    }
}

