/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.util;

import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.type.AllowNull;
import com.github.leeonky.dal.type.SubType;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.GenericType;
import com.github.leeonky.util.PropertyReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class WrappedObject {
    private final Object instance;
    private final BeanClass<Object> beanClass;
    private final RuntimeContext runtimeContext;

    public WrappedObject(Object instance, RuntimeContext context) {
        this.instance = instance;
        this.beanClass = instance == null ? null : BeanClass.create(instance.getClass());
        this.runtimeContext = context;
    }

    public boolean isList() {
        return this.instance != null && (this.runtimeContext.isRegisteredList(this.instance) || this.instance instanceof Iterable || this.instance.getClass().isArray());
    }

    public Set<String> getPropertyReaderNames() {
        return this.runtimeContext.findPropertyReaderNames(this.instance).orElseGet(() -> {
            if (this.instance instanceof Map) {
                return ((Map)this.instance).keySet();
            }
            return this.beanClass.getPropertyReaders().keySet();
        });
    }

    public Object getPropertyValue(String name) {
        if (name.contains(".")) {
            String[] split = name.split("\\.", 2);
            return this.getWrappedPropertyValue(split[0]).getPropertyValue(split[1]);
        }
        return this.instance instanceof Map ? ((Map)this.instance).get(name) : this.getPropertyFromType(name);
    }

    public WrappedObject getWrappedPropertyValue(String name) {
        return this.runtimeContext.wrap(this.getPropertyValue(name));
    }

    public int getListSize() {
        int size = 0;
        for (Object ignore : this.getList()) {
            ++size;
        }
        return size;
    }

    public Iterable getList() {
        return this.runtimeContext.gitList(this.instance).orElseGet(() -> {
            if (this.instance instanceof Iterable) {
                return (Iterable)this.instance;
            }
            return () -> new Iterator(){
                private final int length;
                private int index;
                {
                    this.length = Array.getLength(WrappedObject.this.instance);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                public Object next() {
                    return Array.get(WrappedObject.this.instance, this.index++);
                }
            };
        });
    }

    public Iterable<WrappedObject> getWrappedList() {
        ArrayList<WrappedObject> result = new ArrayList<WrappedObject>();
        for (Object object : this.getList()) {
            result.add(this.runtimeContext.wrap(object));
        }
        return result;
    }

    private Object getPropertyFromType(String name) {
        return this.runtimeContext.getPropertyValue(this.instance, name).orElseGet(() -> this.beanClass.getPropertyValue(this.instance, name));
    }

    public Boolean isNull() {
        return this.runtimeContext.isNull(this.instance);
    }

    private BeanClass getPolymorphicSchemaType(Class<?> superSchemaType) {
        Class type = superSchemaType;
        SubType subType = superSchemaType.getAnnotation(SubType.class);
        if (subType != null) {
            Object value = this.getPropertyValue(subType.property());
            type = Stream.of(subType.types()).filter(t -> t.value().equals(value)).map(SubType.Type::type).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Cannot guess sub type through property type value[%s]", value)));
        }
        return BeanClass.create(type);
    }

    public boolean verifySchema(Class<?> schemaType, String subPrefix) {
        BeanClass polymorphicBeanClass = this.getPolymorphicSchemaType(schemaType);
        Set<String> propertyReaderNames = this.getPropertyReaderNames();
        return this.noMoreUnexpectedField(polymorphicBeanClass, polymorphicBeanClass.getPropertyReaders().keySet(), propertyReaderNames) && this.allMandatoryPropertyShouldBeExist(polymorphicBeanClass, propertyReaderNames) && this.allPropertyValueShouldBeValid(subPrefix, polymorphicBeanClass);
    }

    private boolean allMandatoryPropertyShouldBeExist(BeanClass<?> polymorphicBeanClass, Set<String> actualFields) {
        return polymorphicBeanClass.getPropertyReaders().values().stream().filter(this.isAllowNull().negate()).filter(propertyReader -> !actualFields.contains(propertyReader.getName())).peek(propertyReader -> System.err.printf("Expected field `%s` for type %s[%s], but does not exist\n", propertyReader.getName(), polymorphicBeanClass.getSimpleName(), polymorphicBeanClass.getName())).count() == 0L;
    }

    private Predicate<PropertyReader<?>> isAllowNull() {
        return propertyReader -> propertyReader.getAnnotation(AllowNull.class) != null;
    }

    private boolean noMoreUnexpectedField(BeanClass polymorphicBeanClass, Set<String> expectedFields, Set<String> actualFields) {
        return actualFields.stream().filter(f -> !expectedFields.contains(f)).peek(f -> System.err.printf("Unexpected field `%s` for type %s[%s]\n", f, polymorphicBeanClass.getSimpleName(), polymorphicBeanClass.getName())).count() == 0L;
    }

    private boolean allPropertyValueShouldBeValid(String subPrefix, BeanClass<?> polymorphicBeanClass) {
        return polymorphicBeanClass.getPropertyReaders().values().stream().noneMatch(propertyReader -> {
            WrappedObject propertyValueWrapper = this.getWrappedPropertyValue(propertyReader.getName());
            if (this.isAllowNull().test((PropertyReader<?>)propertyReader) && propertyValueWrapper.isNull().booleanValue()) {
                return false;
            }
            return !propertyValueWrapper.verifySchemaInGenericType(subPrefix + "." + propertyReader.getName(), propertyReader.getGenericType());
        });
    }

    private boolean verifySchemaInGenericType(String subPrefix, GenericType genericType) {
        Class fieldType = genericType.getRawType();
        if (Formatter.class.isAssignableFrom(fieldType)) {
            return this.verifyFormatterValue(subPrefix, (Formatter)BeanClass.newInstance((Class)fieldType, (Object[])new Object[0]));
        }
        if (this.runtimeContext.isRegistered(fieldType)) {
            return this.verifySchema(fieldType, subPrefix);
        }
        if (Iterable.class.isAssignableFrom(fieldType)) {
            return this.verifyList(subPrefix, genericType);
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return this.verifyMap(subPrefix, genericType);
        }
        return true;
    }

    private boolean verifyFormatterValue(String subPrefix, Formatter<Object> formatter) {
        if (formatter.isValidValue(this.instance)) {
            return true;
        }
        System.err.printf("Expected field `%s` should be in %s, but was [%s]\n", subPrefix, formatter.getFormatterName(), this.instance);
        return false;
    }

    private boolean verifyList(String subPrefix, GenericType genericType) {
        int index = 0;
        GenericType subGenericType = (GenericType)genericType.getGenericTypeParameter(0).orElseThrow(() -> new IllegalArgumentException(subPrefix + " should be generic type"));
        for (WrappedObject wrappedElement : this.getWrappedList()) {
            if (wrappedElement.verifySchemaInGenericType(String.format("%s[%d]", subPrefix, index++), subGenericType)) continue;
            return false;
        }
        return true;
    }

    private boolean verifyMap(String subPrefix, GenericType genericType) {
        GenericType subGenericType = (GenericType)genericType.getGenericTypeParameter(1).orElseThrow(() -> new IllegalArgumentException(subPrefix + " should be generic type"));
        return this.getPropertyReaderNames().stream().allMatch(key -> this.getWrappedPropertyValue((String)key).verifySchemaInGenericType(subPrefix + "." + key, subGenericType));
    }
}

