/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.Constructor;
import com.github.leeonky.dal.NameStrategy;
import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Formatters;
import com.github.leeonky.dal.token.IllegalTypeException;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.dal.util.TypeData;
import com.github.leeonky.dal.util.WrappedObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RuntimeContextBuilder {
    private final TypeData<PropertyAccessor> propertyAccessors = new TypeData();
    private final TypeData<ListAccessor> listAccessors = new TypeData();
    private final Map<String, Constructor> constructors = new LinkedHashMap<String, Constructor>();
    private final Set<Class<?>> schemas = new HashSet();

    public RuntimeContextBuilder() {
        this.registerValueFormat(new Formatters.String());
        this.registerValueFormat(new Formatters.URL());
        this.registerValueFormat(new Formatters.Instant());
        this.registerValueFormat(new Formatters.LocalDate());
        this.registerValueFormat(new Formatters.LocalDateTime());
        this.registerValueFormat(new Formatters.Enum());
        this.registerValueFormat(new Formatters.Number());
        this.registerValueFormat(new Formatters.PositiveInteger());
        this.registerValueFormat(new Formatters.Integer());
        this.registerValueFormat(new Formatters.PositiveNumber());
        this.registerValueFormat(new Formatters.ZeroNumber());
        this.registerValueFormat(new Formatters.Boolean());
        this.registerSchema("List", WrappedObject::isList);
    }

    public RuntimeContext build(Object inputValue) {
        return new RuntimeContext(inputValue, this.propertyAccessors, this.constructors, this.listAccessors, this.schemas);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter formatter) {
        this.constructors.put(name, (o, context) -> formatter.transform(o));
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<?> clazz) {
        return this.registerSchema(clazz, NameStrategy.SIMPLE_NAME);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<?> clazz) {
        this.schemas.add(clazz);
        return this.registerSchema(name, (WrappedObject bw) -> bw.createSchemaVerifier().verify(clazz, null, ""));
    }

    public RuntimeContextBuilder registerSchema(String name, Function<WrappedObject, Boolean> predicate) {
        this.constructors.put(name, (o, context) -> {
            if (o != null && ((Boolean)predicate.apply(context.wrap(o))).booleanValue()) {
                return o;
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T> RuntimeContextBuilder registerListAccessor(Class<T> type, ListAccessor<T> listAccessor) {
        this.listAccessors.put(type, listAccessor);
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<?> clazz, NameStrategy nameStrategy) {
        return this.registerSchema(nameStrategy.toName(clazz), clazz);
    }
}

