/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.token.IllegalTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class BaseFormatter<T, R>
implements Formatter<T, R> {
    private final Class<T> inputType = BaseFormatter.guessInputType(this.getClass().getGenericSuperclass());

    protected BaseFormatter() {
    }

    public static Class<?> guessInputType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType().equals(BaseFormatter.class)) {
                return (Class)parameterizedType.getActualTypeArguments()[0];
            }
            return BaseFormatter.guessInputType(parameterizedType.getRawType());
        }
        if (type instanceof Class) {
            return BaseFormatter.guessInputType(((Class)type).getGenericSuperclass());
        }
        throw new IllegalStateException("Cannot guess input type.");
    }

    public static <T, R> R toValueOrThrowIllegalTypeException(T arg, ParseBlock<T, R> parseBlock) {
        try {
            return parseBlock.run(arg);
        }
        catch (Exception e) {
            throw new IllegalTypeException();
        }
    }

    @Override
    public boolean isValidType(Object input) {
        return this.inputType.isInstance(input);
    }

    @FunctionalInterface
    public static interface ParseBlock<T2, R2> {
        public R2 run(T2 var1) throws Exception;
    }
}

