/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.token;

public class SourceCode {
    private int offset = 0;
    private char[] charBuffer;
    private String sourceCode;

    public SourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
        this.charBuffer = sourceCode.toCharArray();
    }

    public int getPosition() {
        return this.offset;
    }

    public boolean startsWith(String prefix) {
        return this.sourceCode.startsWith(prefix, this.offset);
    }

    public SourceCode trimLeft() {
        while (this.offset < this.charBuffer.length && Character.isWhitespace(this.getChar())) {
            ++this.offset;
        }
        return this;
    }

    public char getChar() {
        return this.charBuffer[this.offset];
    }

    public char takeChar() {
        return this.charBuffer[this.offset++];
    }

    public boolean hasContent() {
        this.trimLeft();
        return this.notEnd();
    }

    public boolean notEnd() {
        return this.offset < this.charBuffer.length;
    }

    public void seek(int p) {
        this.offset += p;
    }
}

