/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.util;

import com.github.leeonky.dal.RuntimeContext;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.type.AllowNull;
import com.github.leeonky.dal.type.SubType;
import com.github.leeonky.dal.util.WrappedObject;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.GenericType;
import com.github.leeonky.util.PropertyReader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SchemaVerifier {
    private final WrappedObject object;
    private final RuntimeContext runtimeContext;

    public SchemaVerifier(RuntimeContext runtimeContext, WrappedObject object) {
        this.runtimeContext = runtimeContext;
        this.object = object;
    }

    private <T> BeanClass<T> getPolymorphicSchemaType(Class<?> superSchemaType) {
        Class type = superSchemaType;
        SubType subType = superSchemaType.getAnnotation(SubType.class);
        if (subType != null) {
            Object value = this.object.getPropertyValue(subType.property());
            type = Stream.of(subType.types()).filter(t -> t.value().equals(value)).map(SubType.Type::type).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Cannot guess sub type through property type value[%s]", value)));
        }
        return BeanClass.create(type);
    }

    public boolean verify(Class<?> clazz, Object schemaInstance, String subPrefix) {
        Set<String> propertyReaderNames = this.object.getPropertyReaderNames();
        BeanClass schema = this.getPolymorphicSchemaType(clazz);
        return this.noMoreUnexpectedField(schema, schema.getPropertyReaders().keySet(), propertyReaderNames) && this.allMandatoryPropertyShouldBeExist(schema, propertyReaderNames) && this.allPropertyValueShouldBeValid(subPrefix, schema, schemaInstance == null ? schema.newInstance(new Object[0]) : schemaInstance);
    }

    private boolean noMoreUnexpectedField(BeanClass polymorphicBeanClass, Set<String> expectedFields, Set<String> actualFields) {
        return actualFields.stream().allMatch(f -> this.shouldNotContainsUnexpectedField(polymorphicBeanClass, expectedFields, (String)f));
    }

    private <T> boolean allMandatoryPropertyShouldBeExist(BeanClass<T> polymorphicBeanClass, Set<String> actualFields) {
        return polymorphicBeanClass.getPropertyReaders().values().stream().filter(propertyReader -> propertyReader.getAnnotation(AllowNull.class) == null).allMatch(propertyReader -> this.shouldContainsField(actualFields, polymorphicBeanClass, (PropertyReader)propertyReader));
    }

    private <T> boolean allPropertyValueShouldBeValid(String subPrefix, BeanClass<T> polymorphicBeanClass, T schemaInstance) {
        return polymorphicBeanClass.getPropertyReaders().values().stream().allMatch(propertyReader -> {
            WrappedObject wrappedPropertyValue = this.object.getWrappedPropertyValue(propertyReader.getName());
            return this.allowNullAndIsNull((PropertyReader)propertyReader, wrappedPropertyValue) || wrappedPropertyValue.createSchemaVerifier().verifySchemaInGenericType(subPrefix + "." + propertyReader.getName(), propertyReader.getGenericType(), propertyReader.getValue(schemaInstance));
        });
    }

    private <T> boolean allowNullAndIsNull(PropertyReader<T> propertyReader, WrappedObject propertyValueWrapper) {
        return propertyReader.getAnnotation(AllowNull.class) != null && propertyValueWrapper.isNull();
    }

    private boolean shouldNotContainsUnexpectedField(BeanClass polymorphicBeanClass, Set<String> expectedFields, String f) {
        return expectedFields.contains(f) || this.errorLog("Unexpected field `%s` for type %s[%s]\n", f, polymorphicBeanClass.getSimpleName(), polymorphicBeanClass.getName());
    }

    private <T> boolean shouldContainsField(Set<String> actualFields, BeanClass<T> polymorphicBeanClass, PropertyReader<T> propertyReader) {
        return actualFields.contains(propertyReader.getName()) || this.errorLog("Expected field `%s` for type %s[%s], but does not exist\n", propertyReader.getName(), polymorphicBeanClass.getSimpleName(), polymorphicBeanClass.getName());
    }

    private boolean errorLog(String format, Object ... params) {
        System.err.printf(format, params);
        return false;
    }

    private <T> boolean verifySchemaInGenericType(String subPrefix, GenericType genericType, Object schemaProperty) {
        Class fieldType = genericType.getRawType();
        if (Formatter.class.isAssignableFrom(fieldType)) {
            return this.verifyFormatterValue(subPrefix, this.getOrCreateFormatter(schemaProperty, genericType));
        }
        if (this.runtimeContext.isRegistered(fieldType)) {
            return this.object.createSchemaVerifier().verify(fieldType, schemaProperty, subPrefix);
        }
        if (Iterable.class.isAssignableFrom(fieldType)) {
            return this.verifyList(subPrefix, genericType, (Iterable)schemaProperty);
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return this.verifyMap(subPrefix, genericType, (Map)schemaProperty);
        }
        if (fieldType.isArray()) {
            return this.verifyArray(subPrefix, fieldType.getComponentType(), (Object[])schemaProperty);
        }
        return true;
    }

    private boolean verifyArray(String subPrefix, Class<?> elementType, Object[] schemaProperty) {
        List wrappedObjectList = StreamSupport.stream(this.object.getWrappedList().spliterator(), false).collect(Collectors.toList());
        if (schemaProperty == null) {
            return IntStream.range(0, wrappedObjectList.size()).allMatch(i -> ((WrappedObject)wrappedObjectList.get(i)).createSchemaVerifier().verifySchemaInGenericType(String.format("%s[%d]", subPrefix, i), GenericType.createGenericType((Type)elementType), null));
        }
        List<Object> schemaPropertyList = Arrays.asList(schemaProperty);
        return this.shouldBeSameSize(subPrefix, wrappedObjectList, schemaPropertyList) && IntStream.range(0, wrappedObjectList.size()).allMatch(i -> ((WrappedObject)wrappedObjectList.get(i)).createSchemaVerifier().verifySchemaInGenericType(String.format("%s[%d]", subPrefix, i), GenericType.createGenericType((Type)elementType), schemaPropertyList.get(i)));
    }

    private Formatter<Object, Object> getOrCreateFormatter(Object schemaProperty, GenericType genericType) {
        if (schemaProperty != null) {
            return (Formatter)schemaProperty;
        }
        Class fieldType = genericType.getRawType();
        return (Formatter)genericType.getGenericTypeParameter(0).map(t -> BeanClass.newInstance((Class)fieldType, (Object[])new Object[]{t.getRawType()})).orElseGet(() -> BeanClass.newInstance((Class)fieldType, (Object[])new Object[0]));
    }

    private boolean verifyList(String subPrefix, GenericType genericType, Iterable<Object> schemaProperties) {
        GenericType subGenericType = (GenericType)genericType.getGenericTypeParameter(0).orElseThrow(() -> new IllegalArgumentException(subPrefix + " should be generic type"));
        List wrappedObjectList = StreamSupport.stream(this.object.getWrappedList().spliterator(), false).collect(Collectors.toList());
        if (schemaProperties == null) {
            return IntStream.range(0, wrappedObjectList.size()).allMatch(i -> ((WrappedObject)wrappedObjectList.get(i)).createSchemaVerifier().verifySchemaInGenericType(String.format("%s[%d]", subPrefix, i), subGenericType, null));
        }
        List schemaPropertyList = StreamSupport.stream(schemaProperties.spliterator(), false).collect(Collectors.toList());
        return this.shouldBeSameSize(subPrefix, wrappedObjectList, schemaPropertyList) && IntStream.range(0, wrappedObjectList.size()).allMatch(i -> ((WrappedObject)wrappedObjectList.get(i)).createSchemaVerifier().verifySchemaInGenericType(String.format("%s[%d]", subPrefix, i), subGenericType, schemaPropertyList.get(i)));
    }

    private boolean verifyMap(String subPrefix, GenericType genericType, Map<?, Object> schemaProperty) {
        GenericType subGenericType = (GenericType)genericType.getGenericTypeParameter(1).orElseThrow(() -> new IllegalArgumentException(String.format("`%s` should be generic type", subPrefix)));
        if (schemaProperty == null) {
            return this.object.getPropertyReaderNames().stream().allMatch(key -> this.object.getWrappedPropertyValue((String)key).createSchemaVerifier().verifySchemaInGenericType(subPrefix + "." + key, subGenericType, null));
        }
        return this.shouldBeSameSize(subPrefix, this.object.getPropertyReaderNames(), schemaProperty.values()) && this.object.getPropertyReaderNames().stream().allMatch(key -> this.object.getWrappedPropertyValue((String)key).createSchemaVerifier().verifySchemaInGenericType(subPrefix + "." + key, subGenericType, schemaProperty.get(key)));
    }

    private boolean shouldBeSameSize(String subPrefix, Collection<?> wrappedObjectList, Collection<?> schemaPropertyList) {
        return wrappedObjectList.size() == schemaPropertyList.size() || this.errorLog("Expected field `%s` should be size [%d], but was size [%d]\n", subPrefix, schemaPropertyList.size(), wrappedObjectList.size());
    }

    private boolean verifyFormatterValue(String subPrefix, Formatter<Object, Object> formatter) {
        return formatter.isValid(this.object.getInstance()) || this.errorLog("Expected field `%s` should be in `%s`, but was [%s]\n", subPrefix, formatter.getFormatterName(), this.object.getInstance());
    }
}

