/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PropertyNode
extends Node {
    private final Node instanceNode;
    private final Object name;
    private final Type type;

    public PropertyNode(Node instanceNode, Object name, Type type) {
        this.instanceNode = instanceNode;
        this.name = name;
        this.type = type;
    }

    @Override
    public Data evaluateDataObject(RuntimeContextBuilder.RuntimeContext context) {
        try {
            return this.instanceNode.evaluateDataObject(context).getValue(this.name);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RuntimeException("Index out of bounds (" + ex.getMessage() + ")", this.getPositionBegin());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Get property via `%s` failed, property can be public field, getter or customer type getter:\n\t" + e.getMessage(), this.inspect()), this.getPositionBegin());
        }
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.RuntimeContext context) {
        return this.evaluateDataObject(context).getInstance();
    }

    public boolean equals(Object obj) {
        return obj instanceof PropertyNode && Objects.equals(this.instanceNode, ((PropertyNode)obj).instanceNode) && Objects.equals(this.name, ((PropertyNode)obj).name);
    }

    public List<Object> getChain() {
        return new ArrayList<Object>(){
            {
                if (PropertyNode.this.instanceNode instanceof PropertyNode) {
                    this.addAll(((PropertyNode)PropertyNode.this.instanceNode).getChain());
                }
                this.add(PropertyNode.this.name);
            }
        };
    }

    @Override
    public String inspect() {
        return this.type.format(this.instanceNode.inspect(), this.name);
    }

    @Override
    public Object getRootName() {
        Object parentRoot = this.instanceNode.getRootName();
        return parentRoot == null ? this.name : parentRoot;
    }

    @Override
    public Node avoidListMapping() {
        if ("@".equals(this.name)) {
            throw new SyntaxException("element property needed", this.getPositionBegin());
        }
        return this;
    }

    public static enum Type {
        DOT("%s.%s"),
        IDENTIFIER("%s%s"),
        BRACKET("%s[%s]"){

            @Override
            protected String valueString(Object value) {
                return value instanceof String ? String.format("'%s'", value) : String.valueOf(value);
            }
        };

        private final String format;

        private Type(String format) {
            this.format = format;
        }

        protected String valueString(Object value) {
            return String.valueOf(value);
        }

        public String format(String input, Object value) {
            return String.format(this.format, input, this.valueString(value));
        }
    }
}

