/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Expression;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.ObjectNode;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.compiler.ExpressionClause;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowNode
extends Node {
    private final List<Node> cells;
    private final Optional<Integer> index;
    private final Optional<Operator> operator;
    private final Optional<ExpressionClause> schemaClause;

    public RowNode(Optional<Integer> index, Optional<ExpressionClause> schemaClause, Optional<Operator> operator, List<Node> cells) {
        this.cells = cells;
        this.operator = operator;
        this.schemaClause = schemaClause;
        this.index = index;
        this.setPositionBegin(cells.get(0).getOperandPosition());
    }

    public static String printTableRow(Stream<String> stream) {
        return stream.collect(Collectors.joining(" | ", "| ", " |"));
    }

    public static String printTableRow(Collection<String> collection) {
        return RowNode.printTableRow(collection.stream());
    }

    @Override
    public String inspect() {
        return this.inspectSchemaAndOperator() + this.cells.stream().map(Node::inspectClause).collect(Collectors.joining(" | ", "| ", " |"));
    }

    public String inspectSchemaAndOperator() {
        return this.index.map(i -> i + " ").orElse("") + this.schemaClause.map(clause -> clause.makeExpression(null).inspectClause() + " ").orElse("") + this.operator.map(o -> o.inspect("", "")).orElse("");
    }

    private boolean isRowWildcard() {
        return this.cells.size() >= 1 && this.cells.get(0) instanceof WildcardNode;
    }

    private boolean isEllipsis() {
        return this.cells.size() >= 1 && this.cells.get(0) instanceof ListEllipsisNode;
    }

    public ExpressionClause toExpressionClause(Operator operator) {
        return input -> this.isEllipsis() ? this.cells.get(0) : this.transformRowToExpression(operator, this.index.map(i -> new PropertyNode(InputNode.INSTANCE, i, PropertyNode.Type.BRACKET)).orElse(input));
    }

    private Expression transformRowToExpression(Operator operator, Node inputElement) {
        return new Expression(this.schemaClause.map(c -> c.makeExpression(inputElement)).orElse(inputElement), this.operator.orElse(operator), this.isRowWildcard() ? this.cells.get(0) : new ObjectNode(this.cells).setPositionBegin(this.cells.get(0).getOperandPosition()));
    }

    public boolean hasSchemaOrOperator() {
        return this.operator.isPresent() || this.schemaClause.isPresent() || this.hasIndex();
    }

    public List<Node> getCells() {
        return this.cells;
    }

    public List<String> inspectCells() {
        return this.cells.stream().map(Node::inspectClause).collect(Collectors.toList());
    }

    public boolean hasIndex() {
        return this.index.isPresent();
    }
}

