/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.ast.SchemaWhichExpression;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SchemaExpression
extends Node {
    private final Node instance;
    private final List<SchemaNode> schemaNodes = new ArrayList<SchemaNode>();
    private final ObjectRef objectRef = new ObjectRef();
    private final int dimension;

    public SchemaExpression(Node previous, List<SchemaNode> schemaNodes, int dimension) {
        this.instance = previous;
        this.schemaNodes.addAll(schemaNodes);
        this.dimension = dimension;
    }

    public String getSchemaName() {
        return this.schemaNodes.get(this.schemaNodes.size() - 1).getSchema();
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.RuntimeContext context) {
        try {
            this.schemaNodes.forEach(schemaNode -> this.verifyAndConvertAsSchemaType(context, (SchemaNode)schemaNode, this.objectRef));
            return this.objectRef.instance;
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), this.getPositionBegin());
        }
    }

    @Override
    public Data evaluateDataObject(RuntimeContextBuilder.RuntimeContext context) {
        return context.wrap(this.evaluate(context), this.getSchemaName(), this.dimension > 0);
    }

    private void verifyAndConvertAsSchemaType(RuntimeContextBuilder.RuntimeContext context, SchemaNode schemaNode, ObjectRef objectRef) {
        Data input = this.instance.evaluateDataObject(context);
        if (this.dimension == 1) {
            if (!input.isList()) {
                throw new SyntaxException("Expecting a list but was" + input.inspect(), this.instance.getPositionBegin());
            }
            AtomicInteger index = new AtomicInteger(0);
            objectRef.instance = input.getListObjects().stream().map(element -> this.convertViaSchema(context, schemaNode, (Data)element, String.format("%s[%d]", this.instance.inspect(), index.getAndIncrement()))).collect(Collectors.toList());
        } else {
            objectRef.instance = this.convertViaSchema(context, schemaNode, input, this.instance.inspect());
        }
    }

    private Object convertViaSchema(RuntimeContextBuilder.RuntimeContext context, SchemaNode schemaNode, Data element, String input) {
        try {
            return schemaNode.getConstructorViaSchema(context).apply(element);
        }
        catch (IllegalTypeException exception) {
            throw new AssertionFailure(exception.assertionFailureMessage(input.isEmpty() ? input : input + " ", schemaNode), schemaNode.getPositionBegin());
        }
    }

    @Override
    public String inspect() {
        return (this.instance instanceof InputNode ? "" : this.instance.inspect() + " ") + this.inspectClause();
    }

    private SchemaWhichExpression which(Node whichClause, boolean omitWhich) {
        return (SchemaWhichExpression)new SchemaWhichExpression(this, whichClause, omitWhich).setPositionBegin(this.getPositionBegin());
    }

    public SchemaWhichExpression omitWhich(Node n) {
        return this.which(n, true);
    }

    public SchemaWhichExpression which(Node n) {
        return this.which(n, false);
    }

    @Override
    public String inspectClause() {
        return String.format("is %s%s%s", String.join((CharSequence)"", Collections.nCopies(this.dimension, "[")), this.schemaNodes.stream().map(SchemaNode::inspect).collect(Collectors.joining(String.format(" %s ", "/"))), String.join((CharSequence)"", Collections.nCopies(this.dimension, "]")));
    }

    @Override
    public Object getRootName() {
        return this.instance.getRootName();
    }

    static class ObjectRef {
        public Object instance;

        ObjectRef() {
        }
    }
}

