/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Node;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;

public class SequenceNode
extends Node {
    public static final Comparator<Object> NOP_COMPARATOR = (o1, o2) -> 0;
    public static final SequenceNode NO_SEQUENCE = new SequenceNode(0, Type.AZ, null){

        @Override
        public Comparator<Object> getComparator(Function<Object, Object> orderBy) {
            return NOP_COMPARATOR;
        }
    };
    private final int value;
    private final Type type;
    private final String word;

    public SequenceNode(int value, Type type, String word) {
        this.value = value;
        this.type = type;
        this.word = word;
    }

    public static SequenceNode noSequence() {
        return NO_SEQUENCE;
    }

    @Override
    public String inspect() {
        return this.value == 0 ? "" : String.join((CharSequence)"", Collections.nCopies(this.value, this.word)) + " ";
    }

    public Comparator<Object> getComparator(Function<Object, Object> orderBy) {
        return this.type.azOrZa(Comparator.comparing(o -> (Comparable)orderBy.apply(o)));
    }

    public static Comparator<SequenceNode> comparator() {
        return Comparator.comparingInt(sequenceNode -> sequenceNode.value);
    }

    public static enum Type {
        AZ,
        ZA{

            @Override
            Comparator<Object> azOrZa(Comparator<Object> comparator) {
                return comparator.reversed();
            }
        };


        Comparator<Object> azOrZa(Comparator<Object> comparator) {
            return comparator;
        }
    }
}

