/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.SequenceNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.SchemaVerifier;
import com.github.leeonky.util.BeanClass;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Data {
    private final SchemaType schemaType;
    private final RuntimeContextBuilder.RuntimeContext runtimeContext;
    private final Object instance;
    private List<Object> listValue;
    private Comparator<Object> listComparator = SequenceNode.NOP_COMPARATOR;

    public Data(Object instance, RuntimeContextBuilder.RuntimeContext context, SchemaType schemaType) {
        this.instance = instance;
        this.schemaType = schemaType;
        this.runtimeContext = context.registerPropertyAccessor(instance);
    }

    public String inspect() {
        return this.isNull() ? " null " : String.format(" %s\n<%s>\n", BeanClass.getClassName((Object)this.getInstance()), this.getInstance());
    }

    public Object getInstance() {
        return this.instance;
    }

    public Set<String> getFieldNames() {
        return this.runtimeContext.findPropertyReaderNames(this.instance);
    }

    public boolean isList() {
        return this.runtimeContext.isRegisteredList(this.instance) || this.instance != null && this.instance.getClass().isArray();
    }

    public int getListSize() {
        return this.getListValues().size();
    }

    private List<Object> getListValues() {
        return this.listValue == null ? (this.listValue = StreamSupport.stream(this.runtimeContext.getList(this.instance).spliterator(), false).sorted(this.listComparator).collect(Collectors.toList())) : this.listValue;
    }

    public List<Data> getListObjects() {
        AtomicInteger index = new AtomicInteger(0);
        return this.getListValues().stream().map(object -> new Data(object, this.runtimeContext, this.schemaType.access(index.incrementAndGet()))).collect(Collectors.toList());
    }

    public boolean isNull() {
        return this.runtimeContext.isNull(this.instance);
    }

    public SchemaVerifier createSchemaVerifier() {
        return new SchemaVerifier(this.runtimeContext, this);
    }

    public Data getValue(List<Object> properties) {
        if (properties.isEmpty()) {
            return this;
        }
        return this.getValue(properties.get(0)).getValue(properties.subList(1, properties.size()));
    }

    public Data getValue(Object property) {
        List<Object> propertyChain = this.schemaType.access(property).getPropertyChainBefore(this.schemaType);
        if (propertyChain.size() == 1 && propertyChain.get(0).equals(property)) {
            return new Data(this.getPropertyValue(property), this.runtimeContext, this.propertySchema(property));
        }
        return this.getValue(propertyChain);
    }

    private Object getPropertyValue(Object property) {
        return this.isList() ? this.getValueFromList(property) : this.runtimeContext.getPropertyValue(this.instance, (String)property);
    }

    private Object getValueFromList(Object property) {
        if (this.runtimeContext.isListMapping()) {
            this.runtimeContext.endListMapping();
            return this.getListObjects().stream().map(e -> e.getPropertyValue(property)).collect(Collectors.toList());
        }
        if ("size".equals(property)) {
            return this.getListSize();
        }
        if ("@".equals(property)) {
            this.runtimeContext.beginListMapping();
            return this.instance;
        }
        if (property instanceof String) {
            try {
                return this.runtimeContext.getPropertyValue(this.instance, (String)property);
            }
            catch (Exception e2) {
                this.runtimeContext.beginListMapping();
                return this.getValueFromList(this.subProperty((String)property));
            }
        }
        if ((Integer)property < 0) {
            return this.getListValues().get(this.getListSize() + (Integer)property);
        }
        return this.getListValues().get((Integer)property - this.getListFirstIndex());
    }

    public int getListFirstIndex() {
        return this.runtimeContext.getListFirstIndex(this.instance);
    }

    private Object subProperty(String property) {
        return property.replace("@size", "size");
    }

    private SchemaType propertySchema(Object property) {
        if (this.isList() && property instanceof String) {
            if ("@".equals(property)) {
                return this.schemaType;
            }
            if (!"size".equals(property)) {
                return this.schemaType.mappingAccess(property);
            }
        }
        return this.schemaType.access(property);
    }

    public Object firstFieldFromAlias(Object alias) {
        return this.schemaType.firstFieldFromAlias(alias);
    }

    public Data convert(Class<?> target) {
        return new Data(this.runtimeContext.getConverter().convert(target, this.instance), this.runtimeContext, this.schemaType);
    }

    public Data setListComparator(Comparator<Object> listComparator) {
        this.listComparator = listComparator;
        return this;
    }
}

