/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FunctionUtil {
    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    @SafeVarargs
    public static <T> Optional<T> oneOf(Supplier<Optional<? extends T>> ... optionals) {
        return Stream.of(optionals).map(Supplier::get).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @SafeVarargs
    public static <T> T getValue(final Supplier<? extends T> supplier, final Supplier<? extends T> ... suppliers) {
        return FunctionUtil.getValue(new ArrayList<Supplier<? extends T>>(){
            {
                this.add(supplier);
                this.addAll(Arrays.asList(suppliers));
            }
        });
    }

    private static <T> T getValue(List<Supplier<? extends T>> suppliers) {
        try {
            return suppliers.get(0).get();
        }
        catch (RuntimeException exception) {
            if (suppliers.size() > 1) {
                return FunctionUtil.getValue(suppliers.subList(1, suppliers.size()));
            }
            throw exception;
        }
    }

    public static <T> List<T> allOptional(final Supplier<Optional<T>> optional) {
        return new ArrayList<T>(){
            {
                Optional t = (Optional)optional.get();
                while (t.isPresent()) {
                    this.add(t.get());
                    t = (Optional)optional.get();
                }
            }
        };
    }

    public static <T> List<List<T>> transpose(List<List<T>> list) {
        return FunctionUtil.transpose(list.stream()).collect(Collectors.toList());
    }

    public static <T> Stream<List<T>> transpose(final Stream<List<T>> list) {
        return new LinkedHashMap<Integer, List<T>>(){
            {
                list.forEach((? super T colCells) -> FunctionUtil.eachWithIndex(colCells.stream(), (i, colCell) -> this.computeIfAbsent(i, key -> new ArrayList()).add(colCell)));
            }
        }.values().stream();
    }

    public static <A, B, C> Stream<C> zip(Stream<A> streamA, Stream<B> streamB, final BiFunction<A, B, C> zipper) {
        final Iterator iteratorA = streamA.iterator();
        final Iterator iteratorB = streamB.iterator();
        Iterator iteratorC = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(iteratorA.next(), iteratorB.next());
            }
        };
        return StreamSupport.stream(((Iterable)() -> iteratorC).spliterator(), streamA.isParallel() || streamB.isParallel());
    }

    public static <T> void eachWithIndex(Stream<T> stream, BiConsumer<Integer, T> consumer) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        stream.forEach(element -> consumer.accept(atomicInteger.getAndIncrement(), element));
    }

    public static <T, R> Stream<R> mapWithIndex(Stream<T> stream, BiFunction<Integer, T, R> biFunction) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return stream.map(element -> biFunction.apply(atomicInteger.getAndIncrement(), element));
    }

    public static <T> BinaryOperator<T> notAllowParallelReduce() {
        return (o1, o2) -> {
            throw new IllegalStateException("Not allow parallel here!");
        };
    }
}

