/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.SequenceNode;
import com.github.leeonky.dal.compiler.OperatorMatcher;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.Comparator;
import java.util.Optional;

public class HeaderNode
extends Node {
    private final SequenceNode sequence;
    private final Node property;
    private final Optional<Operator> operator;

    public HeaderNode(SequenceNode sequence, Node property, Optional<Operator> operator) {
        this.sequence = sequence;
        this.property = property;
        this.operator = operator;
    }

    @Override
    public String inspect() {
        String inspect = this.property.inspect();
        return this.sequence.inspect() + this.operator.map(o -> o.inspect(inspect, "").trim()).orElse(inspect);
    }

    public Node getProperty() {
        return this.property;
    }

    public OperatorMatcher headerOperator() {
        return tokenParser -> this.operator;
    }

    public Comparator<Object> getListComparator(RuntimeContextBuilder.RuntimeContext context) {
        return this.sequence.getComparator(o -> context.newThisScope(context.wrap(o), () -> this.property.evaluate(context)));
    }

    public static Comparator<HeaderNode> bySequence() {
        return Comparator.comparing(headerNode -> headerNode.sequence, SequenceNode.comparator().reversed());
    }
}

