/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.compiler.ExpressionClause;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListNode
extends Node {
    private final List<Node> expressions;
    private final List<Node> inputExpressions;
    private final Type type;
    private final boolean multiLineList;

    public ListNode(List<ExpressionClause> expressionFactories, boolean multiLineList) {
        int size = expressionFactories.size();
        this.type = this.guessType(expressionFactories);
        this.inputExpressions = FunctionUtil.mapWithIndex(expressionFactories.stream(), (i, clause) -> clause.makeExpression(new PropertyNode(InputNode.INSTANCE, this.type.indexOfNode((int)i, size), PropertyNode.Type.BRACKET))).collect(Collectors.toList());
        this.expressions = this.type.checkElements(this.inputExpressions).stream().filter(node -> !(node instanceof ListEllipsisNode)).collect(Collectors.toList());
        this.multiLineList = multiLineList;
    }

    public ListNode(List<Node> inputExpressions, boolean multiLineList, Type type) {
        this.inputExpressions = new ArrayList<Node>(inputExpressions);
        this.expressions = this.inputExpressions;
        this.multiLineList = multiLineList;
        this.type = type;
    }

    public ListNode(List<ExpressionClause> expressionFactories) {
        this(expressionFactories, false);
    }

    private Type guessType(List<ExpressionClause> expressionFactories) {
        if (expressionFactories.size() > 0 && expressionFactories.get(expressionFactories.size() - 1).isListEllipsis()) {
            return Type.FIRST_N_ITEMS;
        }
        if (expressionFactories.size() > 0 && expressionFactories.get(0).isListEllipsis()) {
            return Type.LAST_N_ITEMS;
        }
        return Type.ALL_ITEMS;
    }

    public ListNode() {
        this(Collections.emptyList());
    }

    public List<Node> getExpressions() {
        return this.expressions;
    }

    @Override
    public String inspect() {
        return this.inputExpressions.stream().map(Node::inspectClause).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean judge(Node actualNode, Operator.Equal operator, RuntimeContextBuilder.RuntimeContext context) {
        return this.judgeAll(context, actualNode.evaluateDataObject(context));
    }

    @Override
    public boolean judge(Node actualNode, Operator.Matcher operator, RuntimeContextBuilder.RuntimeContext context) {
        return this.judgeAll(context, actualNode.evaluateDataObject(context));
    }

    public boolean judgeAll(RuntimeContextBuilder.RuntimeContext context, DataObject dataObject) {
        if (!dataObject.isList()) {
            throw new RuntimeException(String.format("Cannot compare%sand list", dataObject.inspect()), this.getPositionBegin());
        }
        if (this.type == Type.ALL_ITEMS) {
            AssertionFailure.assertListSize(this.expressions.size(), dataObject.getListSize(), this.getPositionBegin());
        }
        return context.newThisScope(dataObject, () -> this.assertElementExpressions(context));
    }

    private boolean assertElementExpressions(RuntimeContextBuilder.RuntimeContext context) {
        if (this.multiLineList) {
            FunctionUtil.eachWithIndex(this.expressions.stream(), (i, expression) -> {
                try {
                    expression.evaluate(context);
                }
                catch (DalException dalException) {
                    throw new ElementAssertionFailure(this.expressions, (int)i, dalException);
                }
            });
        } else {
            this.expressions.forEach(expression -> expression.evaluate(context));
        }
        return true;
    }

    public static enum Type {
        ALL_ITEMS{

            @Override
            protected Stream<Node> toChecking(List<Node> inputExpressions) {
                return inputExpressions.stream();
            }
        }
        ,
        FIRST_N_ITEMS{

            @Override
            protected Stream<Node> toChecking(List<Node> inputExpressions) {
                return inputExpressions.stream().limit(inputExpressions.size() - 1);
            }
        }
        ,
        LAST_N_ITEMS{

            @Override
            int indexOfNode(int i, int count) {
                return i - count;
            }

            @Override
            protected Stream<Node> toChecking(List<Node> inputExpressions) {
                return inputExpressions.stream().skip(1L);
            }
        };


        int indexOfNode(int i, int count) {
            return i;
        }

        protected abstract Stream<Node> toChecking(List<Node> var1);

        public List<Node> checkElements(List<Node> inputExpressions) {
            this.toChecking(inputExpressions).forEach(node -> {
                if (node instanceof ListEllipsisNode) {
                    throw new SyntaxException("unexpected token", node.getPositionBegin());
                }
            });
            return inputExpressions;
        }
    }
}

