/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.ConstNode;
import com.github.leeonky.dal.ast.EmptyCellNode;
import com.github.leeonky.dal.ast.HeaderNode;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.ListNode;
import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.ObjectNode;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.ParenthesesNode;
import com.github.leeonky.dal.ast.PropertyNode;
import com.github.leeonky.dal.ast.RegexNode;
import com.github.leeonky.dal.ast.RowNode;
import com.github.leeonky.dal.ast.SchemaExpression;
import com.github.leeonky.dal.ast.SchemaWhichExpression;
import com.github.leeonky.dal.ast.SequenceNode;
import com.github.leeonky.dal.ast.TableNode;
import com.github.leeonky.dal.ast.WildcardNode;
import com.github.leeonky.dal.compiler.EscapeChars;
import com.github.leeonky.dal.compiler.ExpressionClause;
import com.github.leeonky.dal.compiler.ExpressionClauseFactory;
import com.github.leeonky.dal.compiler.ExpressionClauseMatcher;
import com.github.leeonky.dal.compiler.ExpressionFactory;
import com.github.leeonky.dal.compiler.ExpressionMatcher;
import com.github.leeonky.dal.compiler.NodeFactory;
import com.github.leeonky.dal.compiler.NodeMatcher;
import com.github.leeonky.dal.compiler.OperatorFactory;
import com.github.leeonky.dal.compiler.OperatorMatcher;
import com.github.leeonky.dal.compiler.SchemaExpressionClauseFactory;
import com.github.leeonky.dal.compiler.SourceCode;
import com.github.leeonky.dal.compiler.TokenParser;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.IfThenFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Compiler {
    private static final OperatorMatcher AND = TokenParser.operatorMatcher("&&", () -> new Operator.And("&&"));
    private static final OperatorMatcher OR = TokenParser.operatorMatcher("||", () -> new Operator.Or("||"));
    private static final OperatorMatcher AND_IN_KEY_WORD = TokenParser.operatorMatcher("and", () -> new Operator.And("and"));
    private static final OperatorMatcher COMMA_AND = TokenParser.operatorMatcher(",", () -> new Operator.And(","), TokenParser::isEnableCommaAnd);
    private static final OperatorMatcher OR_IN_KEY_WORD = TokenParser.operatorMatcher("or", () -> new Operator.Or("or"));
    private static final OperatorMatcher GREATER_OR_EQUAL = TokenParser.operatorMatcher(">=", Operator.GreaterOrEqual::new);
    private static final OperatorMatcher LESS_OR_EQUAL = TokenParser.operatorMatcher("<=", Operator.LessOrEqual::new);
    private static final OperatorMatcher GREATER = TokenParser.operatorMatcher(">", Operator.Greater::new);
    private static final OperatorMatcher LESS = TokenParser.operatorMatcher("<", Operator.Less::new);
    private static final OperatorMatcher PLUS = TokenParser.operatorMatcher("+", Operator.Plus::new);
    private static final OperatorMatcher SUBTRACTION = TokenParser.operatorMatcher("-", Operator.Subtraction::new);
    private static final OperatorMatcher MULTIPLICATION = TokenParser.operatorMatcher("*", Operator.Multiplication::new);
    private static final OperatorMatcher DIVISION = TokenParser.operatorMatcher("/", Operator.Division::new);
    private static final OperatorMatcher NOT_EQUAL = TokenParser.operatorMatcher("!=", Operator.NotEqual::new);
    private static final OperatorMatcher MINUS = TokenParser.operatorMatcher("-", Operator.Minus::new, tokenParser -> !tokenParser.getSourceCode().isBeginning());
    private static final OperatorMatcher NOT = TokenParser.operatorMatcher("!", Operator.Not::new, tokenParser -> !tokenParser.getSourceCode().startsWith("!="));
    private static final OperatorMatcher MATCHER = TokenParser.operatorMatcher(":", Operator.Matcher::new);
    private static final OperatorMatcher EQUAL = TokenParser.operatorMatcher("=", Operator.Equal::new);
    private static final OperatorMatcher BINARY_ARITHMETIC_OPERATORS = Compiler.oneOf(AND, OR, AND_IN_KEY_WORD, COMMA_AND, NOT_EQUAL, OR_IN_KEY_WORD, GREATER_OR_EQUAL, LESS_OR_EQUAL, GREATER, LESS, PLUS, SUBTRACTION, MULTIPLICATION, DIVISION);
    private static final OperatorMatcher UNARY_OPERATORS = Compiler.oneOf(MINUS, NOT);
    private static final OperatorMatcher JUDGEMENT_OPERATORS = Compiler.oneOf(MATCHER, EQUAL);
    private static final EscapeChars SINGLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\'", '\'');
    private static final EscapeChars DOUBLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\n", '\n').escape("\\t", '\t').escape("\\\"", '\"');
    private static final EscapeChars REGEX_ESCAPES = new EscapeChars().escape("\\/", '/');
    NodeMatcher INPUT = TokenParser::fetchInput;
    NodeMatcher NUMBER = TokenParser.NUMBER.map(token -> new ConstNode(token.getNumber()));
    NodeMatcher INTEGER = TokenParser.INTEGER.map(token -> new ConstNode(token.getInteger()));
    NodeMatcher SINGLE_QUOTED_STRING = parser -> parser.fetchString(Character.valueOf('\''), '\'', ConstNode::new, SINGLE_QUOTED_ESCAPES);
    NodeMatcher DOUBLE_QUOTED_STRING = parser -> parser.fetchString(Character.valueOf('\"'), '\"', ConstNode::new, DOUBLE_QUOTED_ESCAPES);
    NodeMatcher CONST_TRUE = parser -> parser.wordToken("true", token -> new ConstNode(true));
    NodeMatcher CONST_FALSE = parser -> parser.wordToken("false", token -> new ConstNode(false));
    NodeMatcher CONST_NULL = parser -> parser.wordToken("null", token -> new ConstNode(null));
    NodeMatcher REGEX = parser -> parser.fetchString(Character.valueOf('/'), '/', RegexNode::new, REGEX_ESCAPES);
    NodeMatcher IDENTITY_PROPERTY = TokenParser.IDENTITY_PROPERTY.map(token -> new PropertyNode(InputNode.INSTANCE, token.getContent(), PropertyNode.Type.IDENTIFIER));
    NodeMatcher WILDCARD = parser -> parser.wordToken("*", token -> new WildcardNode("*"));
    NodeMatcher ROW_WILDCARD = parser -> parser.wordToken("***", token -> new WildcardNode("***"));
    NodeMatcher PROPERTY;
    NodeMatcher OBJECT;
    NodeMatcher LIST;
    NodeMatcher CONST;
    NodeMatcher PARENTHESES;
    NodeMatcher JUDGEMENT;
    NodeMatcher SCHEMA_WHICH_CLAUSE;
    NodeMatcher SCHEMA_JUDGEMENT_CLAUSE;
    NodeMatcher ELEMENT_ELLIPSIS;
    NodeMatcher UNARY_OPERATOR_EXPRESSION;
    NodeMatcher EMPTY_CELL = parser -> IfThenFactory.when(parser.getSourceCode().startsWith("|")).optional(EmptyCellNode::new);
    NodeMatcher TABLE = Compiler.oneOf(new TransposedTableWithRowOperator(), new TableMatcher(), new TransposedTable());
    public NodeFactory PROPERTY_CHAIN;
    public NodeFactory OPERAND;
    public NodeFactory EXPRESSION;
    public NodeFactory LIST_INDEX_OR_MAP_KEY;
    public NodeFactory ARITHMETIC_EXPRESSION;
    public NodeFactory JUDGEMENT_EXPRESSION_OPERAND;
    ExpressionMatcher DOT_PROPERTY = (parser, previous) -> TokenParser.DOT_PROPERTY.map(token -> token.toDotProperty(previous)).fetch(parser);
    ExpressionMatcher BRACKET_PROPERTY;
    ExpressionMatcher EXPLICIT_PROPERTY;
    ExpressionMatcher BINARY_ARITHMETIC_EXPRESSION;
    ExpressionMatcher BINARY_JUDGEMENT_EXPRESSION;
    ExpressionMatcher BINARY_OPERATOR_EXPRESSION;
    ExpressionMatcher SCHEMA_EXPRESSION;
    private static final ExpressionClauseFactory SCHEMA_CLAUSE = new SchemaExpressionClauseFactory();
    private final NodeFactory SEQUENCE = parser -> FunctionUtil.oneOf(parser.sequenceOf("+", SequenceNode.Type.AZ), parser.sequenceOf("-", SequenceNode.Type.ZA), parser.sequenceOf("\u2191", SequenceNode.Type.AZ), parser.sequenceOf("\u2193", SequenceNode.Type.ZA)).orElse(SequenceNode.noSequence());
    private final NodeFactory TABLE_HEADER = parser -> {
        SequenceNode sequence = (SequenceNode)this.SEQUENCE.fetch(parser);
        Node property = this.PROPERTY_CHAIN.fetch(parser);
        return new HeaderNode(sequence, parser.fetchNodeAfter("is", SCHEMA_CLAUSE).map(expressionClause -> expressionClause.makeExpression(property)).orElse(property), JUDGEMENT_OPERATORS.fetch(parser));
    };

    private ExpressionClauseFactory shortJudgementClause(OperatorFactory operatorFactory) {
        return ((ExpressionClauseMatcher)parser -> parser.fetchNodeAfter("is", parser1 -> this.schemaJudgement(parser, SCHEMA_CLAUSE.fetch(parser)))).or(parser -> parser.fetchExpressionClause(operatorFactory, this.JUDGEMENT_EXPRESSION_OPERAND));
    }

    private ExpressionClause schemaJudgement(TokenParser parser, ExpressionClause expressionClause) {
        return parser.fetchExpressionClause(JUDGEMENT_OPERATORS, this.JUDGEMENT_EXPRESSION_OPERAND).map(clause -> previous -> clause.makeExpression(expressionClause.makeExpression(previous))).orElse(expressionClause);
    }

    public Compiler() {
        this.CONST = Compiler.oneOf(this.NUMBER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING, this.CONST_TRUE, this.CONST_FALSE, this.CONST_NULL);
        this.LIST_INDEX_OR_MAP_KEY = Compiler.oneOf(this.INTEGER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING).or("should given one property or array index in `[]`");
        this.PARENTHESES = parser -> parser.enableCommaAnd(() -> parser.fetchNode('(', ')', ParenthesesNode::new, this.EXPRESSION, "expect a value or expression"));
        this.BRACKET_PROPERTY = (parser, previous) -> parser.fetchNode('[', ']', node -> new PropertyNode(previous, ((ConstNode)node).getValue(), PropertyNode.Type.BRACKET), this.LIST_INDEX_OR_MAP_KEY, "should given one property or array index in `[]`");
        this.EXPLICIT_PROPERTY = Compiler.oneOf(this.DOT_PROPERTY, this.BRACKET_PROPERTY);
        this.PROPERTY = Compiler.oneOf(this.EXPLICIT_PROPERTY.defaultInputNode(), this.IDENTITY_PROPERTY);
        this.PROPERTY_CHAIN = parser -> this.PROPERTY.or("expect a object property").recursive(this.EXPLICIT_PROPERTY).fetch(parser);
        this.OBJECT = parser -> parser.disableCommaAnd(() -> parser.fetchNodes(Character.valueOf('{'), '}', ObjectNode::new, () -> this.PROPERTY_CHAIN.withClause(this.shortJudgementClause(JUDGEMENT_OPERATORS.or("expect operator `:` or `=`"))).fetch(parser)));
        this.ELEMENT_ELLIPSIS = parser -> parser.wordToken("...", token -> new ListEllipsisNode());
        this.LIST = parser -> parser.disableCommaAnd(() -> parser.fetchNodes(Character.valueOf('['), ']', ListNode::new, () -> this.ELEMENT_ELLIPSIS.fetch(parser).map(node -> p -> node).orElseGet(() -> this.shortJudgementClause(JUDGEMENT_OPERATORS.or(TokenParser.DEFAULT_JUDGEMENT_OPERATOR)).fetch(parser))));
        this.JUDGEMENT = Compiler.oneOf(this.REGEX, this.OBJECT, this.LIST, this.WILDCARD, this.TABLE);
        this.UNARY_OPERATOR_EXPRESSION = parser -> parser.fetchExpression(null, UNARY_OPERATORS, this.OPERAND);
        this.OPERAND = this.UNARY_OPERATOR_EXPRESSION.or(Compiler.oneOf(this.CONST, this.PROPERTY, this.PARENTHESES, this.INPUT).or("expect a value or expression").recursive(this.EXPLICIT_PROPERTY).map(Node::avoidListMapping));
        this.BINARY_ARITHMETIC_EXPRESSION = (parser, previous) -> parser.fetchExpression(previous, BINARY_ARITHMETIC_OPERATORS, this.OPERAND);
        this.BINARY_JUDGEMENT_EXPRESSION = (parser, previous) -> parser.fetchExpression(previous, JUDGEMENT_OPERATORS, this.JUDGEMENT.or(this.OPERAND));
        this.BINARY_OPERATOR_EXPRESSION = Compiler.oneOf(this.BINARY_ARITHMETIC_EXPRESSION, this.BINARY_JUDGEMENT_EXPRESSION);
        this.ARITHMETIC_EXPRESSION = this.OPERAND.recursive(this.BINARY_ARITHMETIC_EXPRESSION);
        this.JUDGEMENT_EXPRESSION_OPERAND = this.JUDGEMENT.or(this.ARITHMETIC_EXPRESSION);
        this.SCHEMA_JUDGEMENT_CLAUSE = parser -> parser.fetchExpression((Node)InputNode.INSTANCE, JUDGEMENT_OPERATORS, this.JUDGEMENT_EXPRESSION_OPERAND);
        this.SCHEMA_WHICH_CLAUSE = parser -> parser.fetchNodeAfter("which", this.SCHEMA_JUDGEMENT_CLAUSE.or(this.EXPRESSION));
        this.SCHEMA_EXPRESSION = (parser, previous) -> parser.fetchNodeAfter("is", this.compileSchemaExpression(this.whichClause(this.SCHEMA_WHICH_CLAUSE, SchemaExpression::which), this.whichClause(this.SCHEMA_JUDGEMENT_CLAUSE, SchemaExpression::omitWhich)).toNode(previous));
        this.EXPRESSION = this.OPERAND.recursive(Compiler.oneOf(this.BINARY_OPERATOR_EXPRESSION, this.SCHEMA_EXPRESSION));
    }

    private ExpressionFactory compileSchemaExpression(Function<SchemaExpression, NodeMatcher> whichClause1, Function<SchemaExpression, NodeMatcher> whichClause2) {
        return (parser, previous) -> {
            SchemaExpression schemaExpression = (SchemaExpression)SCHEMA_CLAUSE.fetch(parser).makeExpression(previous);
            return Compiler.oneOf((NodeMatcher)whichClause1.apply(schemaExpression), (NodeMatcher)whichClause2.apply(schemaExpression)).fetch(parser).orElse(schemaExpression);
        };
    }

    private Function<SchemaExpression, NodeMatcher> whichClause(NodeMatcher clauseNodeMatcher, BiFunction<SchemaExpression, Node, SchemaWhichExpression> appendWay) {
        return schemaExpression -> clauseNodeMatcher.map(node -> (SchemaWhichExpression)appendWay.apply((SchemaExpression)schemaExpression, (Node)node));
    }

    public List<Node> compile(final SourceCode sourceCode) {
        return new ArrayList<Node>(){
            {
                TokenParser parser = new TokenParser(sourceCode);
                this.add(Compiler.this.EXPRESSION.fetch(parser));
                if (sourceCode.isBeginning() && sourceCode.hasCode()) {
                    throw sourceCode.syntaxError("unexpected token", 0);
                }
                while (sourceCode.hasCode()) {
                    this.add(Compiler.this.EXPRESSION.fetch(parser));
                }
            }
        };
    }

    public List<Object> toChainNodes(String sourceCode) {
        return ((PropertyNode)this.PROPERTY_CHAIN.fetch(new TokenParser(new SourceCode(sourceCode)))).getChain();
    }

    private static NodeMatcher oneOf(NodeMatcher matcher, NodeMatcher ... matchers) {
        return parser -> Stream.concat(Stream.of(matcher), Stream.of(matchers)).map(p -> p.fetch(parser)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private static ExpressionMatcher oneOf(ExpressionMatcher matcher, ExpressionMatcher ... matchers) {
        return (parser, previous) -> Stream.concat(Stream.of(matcher), Stream.of(matchers)).map(p -> p.fetch(parser, previous)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private static OperatorMatcher oneOf(OperatorMatcher matcher, OperatorMatcher ... matchers) {
        return parser -> Stream.concat(Stream.of(matcher), Stream.of(matchers)).map(p -> p.fetch(parser)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private Node getRowCell(TokenParser parser, Optional<Operator> rowOperator, HeaderNode headerNode) {
        int cellPosition = parser.getSourceCode().nextPosition();
        return Compiler.oneOf(this.ELEMENT_ELLIPSIS, this.EMPTY_CELL).or(this.ROW_WILDCARD.or(this.shortJudgementClause(Compiler.oneOf(JUDGEMENT_OPERATORS, headerNode.headerOperator(), parser1 -> rowOperator).or(TokenParser.DEFAULT_JUDGEMENT_OPERATOR)).input(headerNode.getProperty()))).fetch(parser).setPositionBegin(cellPosition);
    }

    private Optional<Integer> getRowIndex(TokenParser parser) {
        return this.INTEGER.fetch(parser).map(node -> (Integer)((ConstNode)node).getValue());
    }

    public class TransposedTableWithRowOperator
    implements NodeMatcher {
        @Override
        public Optional<Node> fetch(TokenParser parser) {
            return parser.getSourceCode().tryFetch(() -> IfThenFactory.when(parser.getSourceCode().popWord("|").isPresent() && parser.getSourceCode().popWord(">>").isPresent()).optional(() -> {
                ArrayList<Optional<Integer>> rowIndexes = new ArrayList<Optional<Integer>>();
                ArrayList<Optional<ExpressionClause>> rowSchemaClauses = new ArrayList<Optional<ExpressionClause>>();
                List<Optional<Operator>> rowOperators = parser.fetchRow(row -> {
                    rowIndexes.add(Compiler.this.getRowIndex(parser));
                    rowSchemaClauses.add(parser.fetchNodeAfter("is", SCHEMA_CLAUSE));
                    return JUDGEMENT_OPERATORS.fetch(parser);
                }).orElse(Collections.emptyList());
                ArrayList<HeaderNode> headerNodes = new ArrayList<HeaderNode>();
                return new TableNode(headerNodes, this.getRowNodes(parser, headerNodes, rowSchemaClauses, rowOperators, rowIndexes), TableNode.Type.TRANSPOSED);
            }));
        }

        private List<RowNode> getRowNodes(TokenParser parser, List<HeaderNode> headerNodes, List<Optional<ExpressionClause>> rowSchemaClauses, List<Optional<Operator>> rowOperators, List<Optional<Integer>> rowIndexes) {
            return FunctionUtil.mapWithIndex(this.getCells(parser, headerNodes, rowOperators), (i, row) -> new RowNode((Optional)rowIndexes.get((int)i), (Optional)rowSchemaClauses.get((int)i), (Optional)rowOperators.get((int)i), (List<Node>)row)).collect(Collectors.toList());
        }

        private Stream<List<Node>> getCells(TokenParser parser, List<HeaderNode> headerNodes, List<Optional<Operator>> rowOperators) {
            return FunctionUtil.transpose(FunctionUtil.allOptional(() -> parser.fetchNodeAfter("|", Compiler.this.TABLE_HEADER).map(HeaderNode.class::cast).map((? super T headerNode) -> {
                headerNodes.add((HeaderNode)headerNode);
                return parser.fetchRow(row -> Compiler.this.getRowCell(parser, (Optional)rowOperators.get((int)row), headerNode)).orElseThrow(() -> parser.getSourceCode().syntaxError("should end with `|`", 0));
            }))).stream();
        }
    }

    public class TransposedTable
    implements NodeMatcher {
        @Override
        public Optional<Node> fetch(TokenParser parser) {
            return parser.getSourceCode().popWord(">>").map((? super T x) -> {
                ArrayList<HeaderNode> headerNodes = new ArrayList<HeaderNode>();
                return new TableNode(headerNodes, this.getRowNodes(parser, headerNodes), TableNode.Type.TRANSPOSED);
            });
        }

        private List<RowNode> getRowNodes(TokenParser parser, List<HeaderNode> headerNodes) {
            return FunctionUtil.transpose(FunctionUtil.allOptional(() -> parser.fetchNodeAfter("|", Compiler.this.TABLE_HEADER).map(HeaderNode.class::cast).map((? super T headerNode) -> {
                headerNodes.add((HeaderNode)headerNode);
                return parser.fetchRow(row -> Compiler.this.getRowCell(parser, Optional.empty(), headerNode)).orElseThrow(() -> parser.getSourceCode().syntaxError("should end with `|`", 0));
            }))).stream().map((? super T row) -> new RowNode(Optional.empty(), Optional.empty(), Optional.empty(), (List<Node>)row)).collect(Collectors.toList());
        }
    }

    public class TableMatcher
    implements NodeMatcher {
        @Override
        public Optional<Node> fetch(TokenParser parser) {
            try {
                return parser.fetchRow(columnIndex -> (HeaderNode)Compiler.this.TABLE_HEADER.fetch(parser)).map((? super T headers) -> new TableNode((List<HeaderNode>)headers, this.getRowNodes(parser, (List<HeaderNode>)headers)));
            }
            catch (IndexOutOfBoundsException ignore) {
                throw parser.getSourceCode().syntaxError("Different cell size", 0);
            }
        }

        protected List<RowNode> getRowNodes(TokenParser parser, List<HeaderNode> headers) {
            return FunctionUtil.allOptional(() -> {
                Optional index = Compiler.this.getRowIndex(parser);
                Optional<ExpressionClause> rowSchemaClause = parser.fetchNodeAfter("is", SCHEMA_CLAUSE);
                Optional<Operator> rowOperator = JUDGEMENT_OPERATORS.fetch(parser);
                return FunctionUtil.oneOf(() -> parser.fetchBetween("|", "|", Compiler.this.ELEMENT_ELLIPSIS).map(Collections::singletonList), () -> parser.fetchBetween("|", "|", Compiler.this.ROW_WILDCARD).map(Collections::singletonList), () -> parser.fetchRow(column -> Compiler.this.getRowCell(parser, rowOperator, (HeaderNode)headers.get((int)column))).map((? super T cellClauses) -> this.checkCellSize(parser, headers, (List<Node>)cellClauses))).map((? super T nodes) -> new RowNode(index, rowSchemaClause, rowOperator, (List<Node>)nodes));
            });
        }

        private List<Node> checkCellSize(TokenParser parser, List<HeaderNode> headers, List<Node> cellClauses) {
            if (cellClauses.size() != headers.size()) {
                throw parser.getSourceCode().syntaxError("Different cell size", 0);
            }
            return cellClauses;
        }
    }
}

