/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.SchemaExpression;
import com.github.leeonky.dal.ast.SchemaNode;
import com.github.leeonky.dal.compiler.ExpressionClause;
import com.github.leeonky.dal.compiler.ExpressionClauseFactory;
import com.github.leeonky.dal.compiler.NodeFactory;
import com.github.leeonky.dal.compiler.TokenParser;
import java.util.List;

public class SchemaExpressionClauseFactory
implements ExpressionClauseFactory {
    public static final NodeFactory SCHEMA = TokenParser.SCHEMA.map(token -> new SchemaNode(token.getContent()));

    @Override
    public ExpressionClause fetch(TokenParser tokenParser) {
        return this.fetchSchemaClause(tokenParser, 0);
    }

    private ExpressionClause fetchSchemaClause(TokenParser tokenParser, int dimension) {
        if (dimension > 1) {
            throw tokenParser.getSourceCode().syntaxError("Not support multidimensional schema", 0);
        }
        return tokenParser.fetchBetween("[", "]", () -> this.fetchSchemaClause(tokenParser, dimension + 1)).orElseGet(() -> {
            List schemaNodes = tokenParser.fetchNodes("/", SCHEMA);
            return input -> new SchemaExpression(input, schemaNodes, dimension);
        });
    }
}

