/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.compiler.Token;
import com.github.leeonky.dal.compiler.TokenMatcher;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.IfThenFactory;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SourceCode {
    private final String code;
    private final char[] chars;
    private int position = 0;

    public static TokenMatcher tokenMatcher(Predicate<Character> startsWith, Collection<String> excluded, boolean trim, Set<Character> delimiters, Predicate<Token> validator) {
        return SourceCode.tokenMatcher(startsWith, excluded, trim, (Character c1, Character c2) -> delimiters.contains(c2), validator);
    }

    public static TokenMatcher tokenMatcher(Predicate<Character> startsWith, Collection<String> excluded, boolean trim, BiPredicate<Character, Character> endsWith, Predicate<Token> validator) {
        return sourceCode -> {
            if (sourceCode.whenFirstChar(startsWith) && sourceCode.hasCode()) {
                if (excluded.stream().noneMatch(sourceCode::startsWith)) {
                    Token token = new Token(sourceCode.position);
                    if (trim) {
                        sourceCode.popChar();
                        sourceCode.leftTrim();
                    }
                    if (sourceCode.hasCode()) {
                        do {
                            token.append(sourceCode.popChar());
                        } while (sourceCode.hasCode() && !endsWith.test(Character.valueOf(token.lastChar()), Character.valueOf(sourceCode.currentChar())));
                    }
                    if (validator.test(token)) {
                        return Optional.of(token);
                    }
                    sourceCode.position = token.getPosition();
                }
            }
            return Optional.empty();
        };
    }

    public SourceCode(String code) {
        this.code = code;
        this.chars = code.toCharArray();
    }

    private int seek(int seek) {
        int position = this.position;
        this.position += seek;
        return position;
    }

    private char currentChar() {
        return this.chars[this.position];
    }

    private char popChar() {
        return this.chars[this.position++];
    }

    private boolean whenFirstChar(Predicate<Character> predicate) {
        return this.leftTrim().hasCode() && predicate.test(Character.valueOf(this.currentChar()));
    }

    public boolean hasCode() {
        return this.position < this.chars.length;
    }

    public SourceCode leftTrim() {
        while (this.hasCode() && Character.isWhitespace(this.currentChar())) {
            ++this.position;
        }
        return this;
    }

    public boolean startsWith(String word) {
        this.leftTrim();
        return this.code.startsWith(word, this.position);
    }

    public char escapedPop(Map<String, Character> escapeChars) {
        return escapeChars.entrySet().stream().filter(e -> this.code.startsWith((String)e.getKey(), this.position)).map(e -> {
            this.seek(((String)e.getKey()).length());
            return (Character)e.getValue();
        }).findFirst().orElseGet(this::popChar).charValue();
    }

    public boolean isBeginning() {
        return CharBuffer.wrap(this.chars).chars().limit(this.position).allMatch(Character::isWhitespace);
    }

    public SyntaxException syntaxError(String message, int positionOffset) {
        return new SyntaxException(message, this.position + positionOffset);
    }

    public Optional<Token> popWord(String word) {
        return this.popWord(word, () -> true);
    }

    public Optional<Token> popWord(String word, Supplier<Boolean> predicate) {
        return IfThenFactory.when(this.startsWith(word) && predicate.get() != false).optional(() -> new Token(this.seek(word.length())).append(word));
    }

    public <T> Optional<Node> fetchElementNode(FetchBy fetchBy, Character opening, char closing, Supplier<T> element, Function<List<T>, Node> nodeFactory) {
        return IfThenFactory.when(this.whenFirstChar(opening::equals)).optional(() -> {
            int startPosition = this.seek(1);
            ArrayList elements = new ArrayList();
            while (this.hasCode() && !fetchBy.isClosing(closing, this)) {
                elements.add(element.get());
                fetchBy.afterFetchElement(this);
            }
            if (!this.hasCode()) {
                throw this.syntaxError(String.format("should end with `%c`", Character.valueOf(closing)), 0);
            }
            this.seek(1);
            return ((Node)nodeFactory.apply(elements)).setPositionBegin(startPosition);
        });
    }

    public Optional<Node> tryFetch(Supplier<Optional<Node>> supplier) {
        int position = this.position;
        Optional<Node> optionalNode = supplier.get();
        if (!optionalNode.isPresent()) {
            this.position = position;
        }
        return optionalNode;
    }

    public <T> Optional<T> repeatWords(String word, IntFunction<T> intFunction) {
        List tokens = FunctionUtil.allOptional(() -> this.popWord(word));
        if (!tokens.isEmpty()) {
            return Optional.of(intFunction.apply(tokens.size()));
        }
        return Optional.empty();
    }

    public boolean isEndOfLine() {
        if (!this.hasCode()) {
            return true;
        }
        while (Character.isWhitespace(this.currentChar()) && this.currentChar() != '\n') {
            this.popChar();
        }
        return this.currentChar() == '\n';
    }

    public int nextPosition() {
        return this.leftTrim().position;
    }

    public static enum FetchBy {
        BY_CHAR,
        BY_NODE{

            @Override
            protected void afterFetchElement(SourceCode sourceCode) {
                sourceCode.popWord(",");
                sourceCode.leftTrim();
            }

            @Override
            protected boolean isClosing(char closing, SourceCode sourceCode) {
                return sourceCode.startsWith(String.valueOf(closing));
            }
        };


        protected void afterFetchElement(SourceCode tokenParser) {
        }

        protected boolean isClosing(char closing, SourceCode sourceCode) {
            return closing == sourceCode.currentChar();
        }
    }
}

