/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.NumberUtil;
import java.util.Objects;
import java.util.function.Supplier;

public class Calculator {
    public static int compare(Object v1, Object v2, Converter converter) {
        if (v1 == null || v2 == null) {
            throw new IllegalArgumentException(String.format("Can not compare [%s] and [%s]", v1, v2));
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            return NumberUtil.compare((Number)((Number)v1), (Number)((Number)v2), (Converter)converter);
        }
        if (v1 instanceof String && v2 instanceof String) {
            return ((String)v1).compareTo((String)v2);
        }
        throw new IllegalArgumentException(String.format("Can not compare [%s: %s] and [%s: %s]", BeanClass.getClassName((Object)v1), v1, BeanClass.getClassName((Object)v2), v2));
    }

    public static boolean equals(DataObject v1, DataObject v2) {
        if (v1.isNull()) {
            return v2.isNull();
        }
        return !v2.isNull() && Objects.equals(v1.getInstance(), v2.getInstance());
    }

    public static Object plus(Object v1, Object v2, Converter converter) {
        if (v1 instanceof Number && v2 instanceof Number) {
            return NumberUtil.plus((Number)((Number)v1), (Number)((Number)v2), (Converter)converter);
        }
        if (v1 instanceof String) {
            return v1.toString() + v2;
        }
        if (v2 instanceof String) {
            return v1 + v2.toString();
        }
        throw new IllegalArgumentException(String.format("Can not plus '%s' and '%s'", BeanClass.getClassName((Object)v1), BeanClass.getClassName((Object)v2)));
    }

    public static Object subtract(Object v1, Object v2, Converter converter) {
        Calculator.requireNumber(v1, v2);
        return NumberUtil.subtract((Number)((Number)v1), (Number)((Number)v2), (Converter)converter);
    }

    public static Object multiply(Object v1, Object v2, Converter converter) {
        Calculator.requireNumber(v1, v2);
        return NumberUtil.multiply((Number)((Number)v1), (Number)((Number)v2), (Converter)converter);
    }

    public static Object divide(Object v1, Object v2, Converter converter) {
        Calculator.requireNumber(v1, v2);
        return NumberUtil.divide((Number)((Number)v1), (Number)((Number)v2), (Converter)converter);
    }

    private static void requireNumber(Object v1, Object v2) {
        if (!(v1 instanceof Number) || !(v2 instanceof Number)) {
            throw new IllegalArgumentException(String.format("Operands should be number but '%s' and '%s'", BeanClass.getClassName((Object)v1), BeanClass.getClassName((Object)v2)));
        }
    }

    public static Object and(Supplier<Object> s1, Supplier<Object> s2) {
        Object v1 = s1.get();
        Calculator.requireBooleanType(v1, "Operand 1");
        if (((Boolean)v1).booleanValue()) {
            Object v2 = s2.get();
            Calculator.requireBooleanType(v2, "Operand 2");
            return v2;
        }
        return false;
    }

    public static Object or(Supplier<Object> s1, Supplier<Object> s2) {
        Object v1 = s1.get();
        Calculator.requireBooleanType(v1, "Operand 1");
        if (!((Boolean)v1).booleanValue()) {
            Object v2 = s2.get();
            Calculator.requireBooleanType(v2, "Operand 2");
            return v2;
        }
        return true;
    }

    public static Object not(Object v) {
        Calculator.requireBooleanType(v, "Operand");
        return (Boolean)v == false;
    }

    public static void requireBooleanType(Object v, String operand) {
        if (!(v instanceof Boolean)) {
            throw new IllegalArgumentException(operand + " should be boolean but '" + BeanClass.getClassName((Object)v) + "'");
        }
    }

    public static Object negate(Object v) {
        if (v instanceof Number) {
            return NumberUtil.negate((Number)((Number)v));
        }
        throw new IllegalArgumentException(String.format("Operands should be number but '%s'", BeanClass.getClassName((Object)v)));
    }
}

