/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Formatters;
import com.github.leeonky.dal.runtime.ClassKeyMap;
import com.github.leeonky.dal.runtime.ConstructorViaSchema;
import com.github.leeonky.dal.runtime.DataObject;
import com.github.leeonky.dal.runtime.FunctionUtil;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.JavaClassPropertyAccessor;
import com.github.leeonky.dal.runtime.ListAccessor;
import com.github.leeonky.dal.runtime.NameStrategy;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuntimeContextBuilder {
    private final ClassKeyMap<PropertyAccessor<Object>> propertyAccessors = new ClassKeyMap();
    private final ClassKeyMap<ListAccessor<Object>> listAccessors = new ClassKeyMap();
    private final Map<String, ConstructorViaSchema> constructors = new LinkedHashMap<String, ConstructorViaSchema>();
    private final Map<String, BeanClass<?>> schemas = new HashMap();
    private Converter converter = Converter.createDefault();
    private final Set<Method> extensionMethods = new HashSet<Method>();

    public RuntimeContextBuilder() {
        this.registerValueFormat(new Formatters.String()).registerValueFormat(new Formatters.URL()).registerValueFormat(new Formatters.Instant()).registerValueFormat(new Formatters.LocalDate()).registerValueFormat(new Formatters.LocalDateTime()).registerValueFormat(new Formatters.Enum()).registerValueFormat(new Formatters.Number()).registerValueFormat(new Formatters.PositiveInteger()).registerValueFormat(new Formatters.Integer()).registerValueFormat(new Formatters.PositiveNumber()).registerValueFormat(new Formatters.ZeroNumber()).registerValueFormat(new Formatters.Boolean()).registerSchema("List", DataObject::isList).registerListAccessor(Iterable.class, iterable -> iterable).registerListAccessor(Stream.class, stream -> stream::iterator).registerPropertyAccessor(Map.class, new PropertyAccessor<Map<String, ?>>(){

            @Override
            public Object getValue(Map<String, ?> instance, String name) {
                return instance.get(name);
            }

            @Override
            public Set<String> getPropertyNames(Map<String, ?> instance) {
                return instance.keySet();
            }

            @Override
            public boolean isNull(Map<String, ?> instance) {
                return instance == null;
            }
        });
    }

    public RuntimeContext build(Object inputValue) {
        return new RuntimeContext(inputValue);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter<?, ?> formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter<?, ?> formatter) {
        this.constructors.put(name, o -> formatter.transform(o.getInstance()));
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<?> schema) {
        return this.registerSchema(NameStrategy.SIMPLE_NAME, schema);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<?> schema) {
        this.schemas.put(name, BeanClass.create(schema));
        return this.registerSchema(name, (DataObject dataObject) -> dataObject.createSchemaVerifier().verify(schema, null, ""));
    }

    public RuntimeContextBuilder registerSchema(String name, Function<DataObject, Boolean> predicate) {
        this.constructors.put(name, o -> {
            if (((Boolean)predicate.apply((DataObject)o)).booleanValue()) {
                return o.getInstance();
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<? extends T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T> RuntimeContextBuilder registerListAccessor(Class<T> type, ListAccessor<? extends T> listAccessor) {
        this.listAccessors.put(type, listAccessor);
        return this;
    }

    public RuntimeContextBuilder registerSchema(NameStrategy nameStrategy, Class<?> schema) {
        return this.registerSchema(nameStrategy.toName(schema), schema);
    }

    public RuntimeContextBuilder setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public RuntimeContextBuilder registerStaticMethodExtension(Class<?> staticMethodExtensionClass) {
        Stream.of(staticMethodExtensionClass.getMethods()).filter(this::maybeExtensionMethods).forEach(this.extensionMethods::add);
        return this;
    }

    public Object invokeExtensionMethod(Object instance, String name) {
        return FunctionUtil.oneOf(() -> this.findExtensionMethod(instance, name, Class::isAssignableFrom), () -> this.findExtensionMethod(instance, name, Object::equals)).map(method -> {
            try {
                return method.invoke(null, instance);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }).orElseThrow(() -> new IllegalStateException(String.format("Method or property `%s` does not exist in `%s`", name, instance.getClass().getName())));
    }

    private Optional<Method> findExtensionMethod(Object instance, String name, BiPredicate<Class<?>, Class<?>> condition) {
        Stream<Method> methodStream = this.extensionMethods.stream().filter(method -> method.getName().equals(name) && condition.test(method.getParameterTypes()[0], instance.getClass()));
        List methods = methodStream.collect(Collectors.toList());
        if (methods.size() > 1) {
            throw new IllegalStateException("Ambiguous method call:\n" + methods.stream().map(Method::toString).collect(Collectors.joining("\n")));
        }
        return methods.stream().findFirst();
    }

    private boolean maybeExtensionMethods(Method method) {
        return method.getParameterCount() == 1 && (9 & method.getModifiers()) != 0;
    }

    public class RuntimeContext {
        private final LinkedList<DataObject> thisStack = new LinkedList();
        private final Set<Class<?>> schemaSet;
        private boolean listMapping = false;

        public RuntimeContext(Object inputValue) {
            this.schemaSet = RuntimeContextBuilder.this.schemas.values().stream().map(BeanClass::getType).collect(Collectors.toSet());
            this.thisStack.push(this.wrap(inputValue));
        }

        public DataObject getInputValue() {
            return this.thisStack.getFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T newThisScope(DataObject dataObject, Supplier<T> supplier) {
            try {
                this.thisStack.push(dataObject);
                T t = supplier.get();
                return t;
            }
            finally {
                this.thisStack.pop();
            }
        }

        public Optional<ConstructorViaSchema> searchConstructor(String type) {
            return Optional.ofNullable(RuntimeContextBuilder.this.constructors.get(type));
        }

        public boolean isSchemaRegistered(Class<?> fieldType) {
            return this.schemaSet.contains(fieldType);
        }

        public Set<String> findPropertyReaderNames(Object instance) {
            return ((PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(instance)).getPropertyNames(instance);
        }

        public Boolean isNull(Object instance) {
            return RuntimeContextBuilder.this.propertyAccessors.tryGetData(instance).map(f -> f.isNull(instance)).orElseGet(() -> Objects.equals(instance, null));
        }

        public Object getPropertyValue(Object instance, String name) {
            return ((PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(instance)).getValue(instance, name);
        }

        public Iterable<Object> getList(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(l -> l.toIterable(instance)).orElseGet(() -> this.arrayIterable(instance));
        }

        public int getListFirstIndex(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.tryGetData(instance).map(ListAccessor::firstIndex).orElse(0);
        }

        private Iterable<Object> arrayIterable(final Object instance) {
            return () -> new Iterator<Object>(){
                private final int length;
                private int index;
                {
                    this.length = Array.getLength(instance);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                @Override
                public Object next() {
                    return Array.get(instance, this.index++);
                }
            };
        }

        public boolean isRegisteredList(Object instance) {
            return RuntimeContextBuilder.this.listAccessors.containsType(instance);
        }

        public Converter getConverter() {
            return RuntimeContextBuilder.this.converter;
        }

        public DataObject wrap(Object instance) {
            return new DataObject(instance, this, SchemaType.createRoot());
        }

        public DataObject wrap(Object instance, String schema, boolean isList) {
            BeanClass schemaBeanClass = (BeanClass)RuntimeContextBuilder.this.schemas.get(schema);
            if (isList) {
                schemaBeanClass = BeanClass.create(Array.newInstance(schemaBeanClass.getType(), 0).getClass());
            }
            return new DataObject(instance, this, SchemaType.create(schemaBeanClass));
        }

        public <T> RuntimeContext registerPropertyAccessor(T instance) {
            if (!Objects.equals(instance, null) && !RuntimeContextBuilder.this.propertyAccessors.containsType(instance)) {
                RuntimeContextBuilder.this.propertyAccessors.put(BeanClass.getClass(instance), new JavaClassPropertyAccessor(RuntimeContextBuilder.this, BeanClass.createFrom(instance)));
            }
            return this;
        }

        public void beginListMapping() {
            this.listMapping = true;
        }

        public boolean isListMapping() {
            return this.listMapping;
        }

        public void endListMapping() {
            this.listMapping = false;
        }
    }
}

