/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.compiler.SourceCode;
import com.github.leeonky.dal.compiler.SyntaxException;
import com.github.leeonky.dal.runtime.AssertResult;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.BeanClass;
import java.util.List;
import java.util.stream.Collectors;

public class DAL {
    private final Compiler compiler = new Compiler();
    private final RuntimeContextBuilder runtimeContextBuilder = new RuntimeContextBuilder();

    public RuntimeContextBuilder getRuntimeContextBuilder() {
        return this.runtimeContextBuilder;
    }

    @Deprecated
    public AssertResult assertTrue(Object actual, String expression) {
        Object result = this.evaluate(actual, expression);
        if (result instanceof Boolean) {
            return (Boolean)result != false ? AssertResult.passedResult() : AssertResult.failedResult(actual, expression);
        }
        throw new IllegalStateException("Verification result should be boolean but '" + BeanClass.getClassName(result) + "'");
    }

    public <T> List<T> evaluateAll(Object input, String expressions) {
        return this.compiler.compile(new SourceCode(expressions)).stream().map(node -> node.evaluate(this.runtimeContextBuilder.build(input))).collect(Collectors.toList());
    }

    public <T> T evaluate(Object input, String expression) {
        List<Node> nodes = this.compiler.compile(new SourceCode(expression));
        if (nodes.size() > 1) {
            throw new SyntaxException("more than one expression", nodes.get(1).getPositionBegin());
        }
        return (T)nodes.get(0).evaluate(this.runtimeContextBuilder.build(input));
    }
}

