/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.Node;
import com.github.leeonky.dal.ast.Operator;
import com.github.leeonky.dal.ast.RuntimeException;
import com.github.leeonky.dal.ast.SchemaExpression;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.Objects;

public class Expression
extends Node {
    private final Node node1;
    private final Operator operator;
    private final Node node2;

    public Expression(Node node1, Operator operator, Node node2) {
        this.node1 = node1;
        this.node2 = node2;
        this.operator = operator;
        this.setPositionBegin(operator.getPosition());
    }

    public Node getLeftOperand() {
        return this.node1;
    }

    public Node getRightOperand() {
        return this.node2;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression adjustOperatorOrder() {
        if (this.node1 instanceof Expression) {
            Expression expression1 = (Expression)this.node1;
            if (this.operator.isPrecedentThan(expression1.operator)) {
                return new Expression(expression1.node1, expression1.operator, new Expression(expression1.node2, this.operator, this.node2).adjustOperatorOrder());
            }
        }
        return this;
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.RuntimeContext context) {
        try {
            Object result = this.operator.calculate(this.node1, this.node2, context);
            if (this.operator.isNeedInspect() && result instanceof Boolean && !((Boolean)result).booleanValue()) {
                System.err.println("Warning: Expression `" + this.inspect() + "` got false.");
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex.getMessage(), this.operator.getPosition());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Expression && Objects.equals(this.node1, ((Expression)obj).node1) && Objects.equals(this.node2, ((Expression)obj).node2) && Objects.equals(this.operator, ((Expression)obj).operator);
    }

    @Override
    public String inspect() {
        return this.operator.inspect(this.node1 == null ? null : this.node1.inspect(), this.node2.inspect());
    }

    @Override
    public Object getRootName() {
        return this.node1.getRootName();
    }

    @Override
    public String inspectClause() {
        if (this.node1 instanceof SchemaExpression) {
            return this.operator.inspect(this.node1.inspectClause(), this.node2.inspect());
        }
        return this.operator.inspect("", this.node2.inspect());
    }

    @Override
    public int getOperandPosition() {
        return this.node2.getPositionBegin();
    }
}

