/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.AssertionFailure;
import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.ast.ListEllipsisNode;
import com.github.leeonky.dal.ast.SortSequenceNode;
import com.github.leeonky.dal.ast.SymbolNode;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListScopeNode
extends DALNode {
    private List<DALNode> expressions__;
    private List<DALNode> inputExpressions;
    private List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories;
    private final Type type;
    private final boolean multiLineList;
    private final Comparator<Object> listComparator;

    public ListScopeNode(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories, boolean multiLineList, Comparator<Object> listComparator) {
        this.type = this.guessType(expressionFactories);
        this.expressionFactories = expressionFactories;
        this.multiLineList = multiLineList;
        this.listComparator = listComparator;
        this.getExpressions(0);
    }

    public ListScopeNode(List<DALNode> inputExpressions, boolean multiLineList, Type type, Comparator<Object> listComparator) {
        this.inputExpressions = new ArrayList<DALNode>(inputExpressions);
        this.expressions__ = this.inputExpressions;
        this.multiLineList = multiLineList;
        this.type = type;
        this.listComparator = listComparator;
    }

    public ListScopeNode(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories) {
        this(expressionFactories, false, SortSequenceNode.NOP_COMPARATOR);
    }

    private List<DALNode> getExpressions(int firstIndex) {
        return this.expressions__ != null ? this.expressions__ : this.type.checkElements(this.getInputExpressions(firstIndex)).stream().filter(node -> !(node instanceof ListEllipsisNode)).collect(Collectors.toList());
    }

    private List<DALNode> getInputExpressions(final int firstIndex) {
        if (this.inputExpressions != null) {
            return this.inputExpressions;
        }
        return new ArrayList<DALNode>(){
            {
                for (int i = 0; i < ListScopeNode.this.expressionFactories.size(); ++i) {
                    this.add(((Clause)ListScopeNode.this.expressionFactories.get(i)).expression(new DALExpression(InputNode.INSTANCE, new DALOperator.PropertyImplicit(), new SymbolNode(ListScopeNode.this.type.indexOfNode(firstIndex, i, ListScopeNode.this.expressionFactories.size()), SymbolNode.Type.BRACKET))));
                }
            }
        };
    }

    private Type guessType(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expressionFactories) {
        if (expressionFactories.size() > 0 && this.isListEllipsis(expressionFactories.get(expressionFactories.size() - 1))) {
            return Type.FIRST_N_ITEMS;
        }
        if (expressionFactories.size() > 0 && this.isListEllipsis(expressionFactories.get(0))) {
            return Type.LAST_N_ITEMS;
        }
        return Type.ALL_ITEMS;
    }

    @Override
    public String inspect() {
        return this.getInputExpressions(0).stream().map(DALNode::inspect).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return this.verifyAll(context, actual);
    }

    @Override
    protected boolean verify(Data actual, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return this.verifyAll(context, actual);
    }

    private boolean verifyAll(RuntimeContextBuilder.DALRuntimeContext context, Data data) {
        data.setListComparator(this.listComparator);
        if (!data.isList()) {
            throw new RuntimeException(String.format("Cannot compare %sand list", data.inspect()), this.getPositionBegin());
        }
        List<DALNode> expressions = this.getExpressions(data.getListFirstIndex());
        if (this.type == Type.ALL_ITEMS) {
            AssertionFailure.assertListSize(expressions.size(), data.getListSize(), this.getPositionBegin());
        }
        return context.newBlockScope(data, () -> this.assertElementExpressions(context, expressions));
    }

    private boolean assertElementExpressions(RuntimeContextBuilder.DALRuntimeContext context, List<DALNode> expressions) {
        if (this.multiLineList) {
            for (int i = 0; i < expressions.size(); ++i) {
                DALNode expression2 = expressions.get(i);
                try {
                    expression2.evaluate(context);
                    continue;
                }
                catch (DalException dalException) {
                    throw new ElementAssertionFailure(i, dalException);
                }
            }
        } else {
            expressions.forEach(expression -> expression.evaluate(context));
        }
        return true;
    }

    private boolean isListEllipsis(Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause) {
        return clause.expression(null) instanceof ListEllipsisNode;
    }

    public static enum Type {
        ALL_ITEMS{

            @Override
            protected Stream<DALNode> toChecking(List<DALNode> inputExpressions) {
                return inputExpressions.stream();
            }
        }
        ,
        FIRST_N_ITEMS{

            @Override
            protected Stream<DALNode> toChecking(List<DALNode> inputExpressions) {
                return inputExpressions.stream().limit(inputExpressions.size() - 1);
            }
        }
        ,
        LAST_N_ITEMS{

            @Override
            int indexOfNode(int firstIndex, int index, int count) {
                return index - count;
            }

            @Override
            protected Stream<DALNode> toChecking(List<DALNode> inputExpressions) {
                return inputExpressions.stream().skip(1L);
            }
        };


        int indexOfNode(int firstIndex, int index, int count) {
            return index + firstIndex;
        }

        protected abstract Stream<DALNode> toChecking(List<DALNode> var1);

        public List<DALNode> checkElements(List<DALNode> inputExpressions) {
            this.toChecking(inputExpressions).forEach(node -> {
                if (node instanceof ListEllipsisNode) {
                    throw new SyntaxException("Unexpected token", node.getPositionBegin());
                }
            });
            return inputExpressions;
        }
    }
}

