/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.interpreter.InterpreterException;

public class Assertions {
    private final Object input;
    private final DAL dal = DAL.getInstance();

    private Assertions(Object input) {
        this.input = input;
    }

    public static Assertions expect(Object input) {
        return new Assertions(input);
    }

    public void should(String dalExpression) {
        this.should("", dalExpression);
    }

    public void should(String prefix, String verification) {
        String fullCode = prefix + verification;
        try {
            this.dal.evaluate(this.input, fullCode);
        }
        catch (InterpreterException e) {
            throw new AssertionError((Object)("\n" + e.show(fullCode, prefix.length()) + "\n" + e.getMessage()));
        }
    }

    public void exact(String verification) {
        this.should("=", verification);
    }

    public void match(String verification) {
        this.should(":", verification);
    }
}

