/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DALExpression
extends DALNode
implements Expression<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator> {
    private final DALNode node1;
    private final DALOperator operator;
    private final DALNode node2;

    public DALExpression(DALNode node1, DALOperator operator, DALNode node2) {
        this.node1 = node1;
        this.node2 = node2;
        this.operator = operator;
        this.setPositionBegin(operator instanceof DALOperator.PropertyImplicit ? node2.getPositionBegin() : operator.getPosition());
    }

    @Override
    public DALNode getLeftOperand() {
        return this.node1;
    }

    @Override
    public DALNode getRightOperand() {
        return this.node2;
    }

    @Override
    public DALOperator getOperator() {
        return this.operator;
    }

    @Override
    public Data evaluateData(RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            Data result = this.operator.calculateData(this.node1, this.node2, context);
            if (this.operator.isNeedInspect() && result.getInstance() instanceof Boolean && !((Boolean)result.getInstance()).booleanValue()) {
                System.err.println("Warning: Expression `" + this.inspect() + "` got false.");
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex.getMessage(), this.operator.getPosition());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof DALExpression && Objects.equals(this.node1, ((DALExpression)obj).node1) && Objects.equals(this.node2, ((DALExpression)obj).node2) && Objects.equals(this.operator, ((DALExpression)obj).operator);
    }

    @Override
    public String inspect() {
        return this.operator.inspect(this.node1 == null ? null : this.node1.inspect(), this.node2.inspect());
    }

    @Override
    public Object getRootSymbolName() {
        return this.node1 instanceof InputNode ? this.node2.getRootSymbolName() : this.node1.getRootSymbolName();
    }

    @Override
    public int getOperandPosition() {
        return this.node2.getPositionBegin();
    }

    @Override
    public List<Object> propertyChain() {
        return new ArrayList<Object>(){
            {
                this.addAll(DALExpression.this.node1.propertyChain());
                this.addAll(DALExpression.this.node2.propertyChain());
            }
        };
    }
}

