/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.DALExpression;
import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.GroupNode;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.ExpressionFactory;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.SourceCode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Supplier;

public class DALProcedure
extends Procedure<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> {
    private final LinkedList<Boolean> enableAndComma = new LinkedList<Boolean>(Collections.singleton(true));
    private boolean enableSlashProperty = false;
    private boolean enableRelaxProperty = false;

    public DALProcedure(SourceCode sourceCode, RuntimeContextBuilder.DALRuntimeContext runtimeContext, ExpressionFactory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator> expressionFactory) {
        super(sourceCode, runtimeContext, expressionFactory);
    }

    public static NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> disableCommaAnd(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return procedure -> procedure.commaAnd(false, () -> nodeParser.parse((DALProcedure)procedure));
    }

    public static NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> enableCommaAnd(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return procedure -> procedure.commaAnd(true, () -> nodeParser.parse((DALProcedure)procedure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> commaAnd(boolean b, Supplier<Optional<T>> nodeFactory) {
        this.enableAndComma.push(b);
        try {
            Optional<T> optional = nodeFactory.get();
            return optional;
        }
        finally {
            this.enableAndComma.pop();
        }
    }

    public boolean isEnableCommaAnd() {
        return this.enableAndComma.getFirst();
    }

    public boolean isCodeBeginning() {
        return this.getSourceCode().isBeginning();
    }

    public boolean mayBeUnEqual() {
        return this.getSourceCode().startsWith(Notations.Operators.NOT_EQUAL);
    }

    public boolean mayBeOpeningGroup() {
        return this.getSourceCode().startsWith(Notations.OPENING_GROUP);
    }

    public boolean mayBeElementEllipsis() {
        return this.getSourceCode().startsWith("..");
    }

    public boolean isEnableSlashProperty() {
        return this.enableSlashProperty;
    }

    public <T> T enableSlashProperty(Supplier<T> supplier) {
        this.enableSlashProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableSlashProperty = false;
        }
    }

    public boolean isEnableRelaxProperty() {
        return this.enableRelaxProperty;
    }

    public <T> T enableRelaxProperty(Supplier<T> supplier) {
        this.enableRelaxProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableRelaxProperty = false;
        }
    }

    @Override
    public DALNode createExpression(DALNode node1, DALOperator operator, DALNode node2) {
        if (node1 instanceof GroupNode && !(operator instanceof DALOperator.Matcher) && !(operator instanceof DALOperator.Equal)) {
            return ((GroupNode)node1).appendChain(n -> this.createExpression((DALNode)n, operator, node2));
        }
        return super.createExpression(node1, operator, node2);
    }
}

