/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.interpreter;

import com.github.leeonky.interpreter.Expression;
import com.github.leeonky.interpreter.IfThenFactory;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.Notation;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.interpreter.Token;
import com.github.leeonky.interpreter.TokenScanner;
import com.github.leeonky.interpreter.TriplePredicate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SourceCode {
    private final String code;
    private int position = 0;
    private int startPosition = 0;
    private final List<Notation> lineComments;

    public static <E extends Expression<C, N, E, O>, N extends Node<C, N>, C extends RuntimeContext<C>, O extends Operator<C, N, O>, S extends Procedure<C, N, E, O, S>> TokenScanner<C, N, E, O, S> tokenScanner(Predicate<Character> startsWith, Set<String> excluded, boolean trimStart, Set<Character> delimiters) {
        return SourceCode.tokenScanner(startsWith, excluded, trimStart, delimiters, (Token token) -> true);
    }

    public static <E extends Expression<C, N, E, O>, N extends Node<C, N>, C extends RuntimeContext<C>, O extends Operator<C, N, O>, S extends Procedure<C, N, E, O, S>> TokenScanner<C, N, E, O, S> tokenScanner(Predicate<Character> startsWith, Set<String> excluded, boolean trimStart, Set<Character> delimiters, Predicate<Token> validator) {
        return SourceCode.tokenScanner(startsWith, excluded, trimStart, (String code, Integer position, Integer size) -> delimiters.contains(Character.valueOf(code.charAt((int)position))), validator);
    }

    public static <E extends Expression<C, N, E, O>, N extends Node<C, N>, C extends RuntimeContext<C>, O extends Operator<C, N, O>, S extends Procedure<C, N, E, O, S>> TokenScanner<C, N, E, O, S> tokenScanner(Predicate<Character> startsWith, Set<String> excluded, boolean trimStart, TriplePredicate<String, Integer, Integer> endsWith, Predicate<Token> predicate) {
        return sourceCode -> sourceCode.tryFetch(() -> IfThenFactory.when(sourceCode.whenFirstChar(startsWith)).optional(() -> {
            Token token = SourceCode.tokenScanner(trimStart, endsWith).scan(sourceCode);
            return !excluded.contains(token.getContent()) && predicate.test(token) ? token : null;
        }));
    }

    public static <E extends Expression<C, N, E, O>, N extends Node<C, N>, C extends RuntimeContext<C>, O extends Operator<C, N, O>, S extends Procedure<C, N, E, O, S>> TokenScanner.Mandatory<C, N, E, O, S> tokenScanner(boolean trimStart, TriplePredicate<String, Integer, Integer> endsWith) {
        return sourceCode -> {
            Token token = new Token(sourceCode.position);
            if (trimStart) {
                sourceCode.popChar();
                sourceCode.trimBlankAndComment();
            }
            int size = 0;
            while (sourceCode.hasCode() && !endsWith.test(sourceCode.code, sourceCode.position, size++)) {
                token.append(sourceCode.popChar());
            }
            return token;
        };
    }

    private SourceCode(String code, List<Notation> lineComments) {
        this.code = code;
        this.lineComments = lineComments;
        this.trimBlankAndComment();
        this.startPosition = this.position;
    }

    public static SourceCode createSourceCode(String code, List<Notation> lineComments) {
        return new SourceCode(code, lineComments);
    }

    private boolean codeStartWith(Notation notation) {
        while (this.hasCode() && Character.isWhitespace(this.currentChar())) {
            ++this.position;
        }
        return this.code.startsWith(notation.getLabel(), this.position);
    }

    private SourceCode trimBlankAndComment() {
        while (this.lineComments.stream().anyMatch(this::codeStartWith)) {
            int newLinePosition = this.code.indexOf("\n", this.position);
            this.position = newLinePosition == -1 ? this.code.length() : newLinePosition + 1;
        }
        return this;
    }

    private int seek(int seek) {
        int position = this.position;
        this.position += seek;
        return position;
    }

    private char currentChar() {
        return this.code.charAt(this.position);
    }

    private char popChar() {
        return this.code.charAt(this.position++);
    }

    private boolean whenFirstChar(Predicate<Character> predicate) {
        return this.trimBlankAndComment().hasCode() && predicate.test(Character.valueOf(this.currentChar()));
    }

    public boolean hasCode() {
        return this.position < this.code.length();
    }

    public boolean startsWith(Notation notation) {
        this.trimBlankAndComment();
        return this.code.startsWith(notation.getLabel(), this.position);
    }

    public boolean startsWith(String word) {
        return this.code.startsWith(word, this.position);
    }

    public char popChar(Map<String, Character> escapeChars) {
        return escapeChars.entrySet().stream().filter(e -> this.code.startsWith((String)e.getKey(), this.position)).map(e -> {
            this.seek(((String)e.getKey()).length());
            return (Character)e.getValue();
        }).findFirst().orElseGet(this::popChar).charValue();
    }

    public boolean isBeginning() {
        return this.code.chars().skip(this.startPosition).limit(this.position - this.startPosition).allMatch(Character::isWhitespace);
    }

    public SyntaxException syntaxError(String message, int positionOffset) {
        return new SyntaxException(message, this.position + positionOffset);
    }

    public Optional<Token> popWord(Notation notation) {
        return this.popWord(notation, () -> true);
    }

    public Optional<Token> popWord(Notation notation, Supplier<Boolean> predicate) {
        return IfThenFactory.when(this.startsWith(notation) && predicate.get() != false).optional(() -> new Token(this.seek(notation.length())).append(notation.getLabel()));
    }

    public <N> Optional<N> tryFetch(Supplier<Optional<N>> supplier) {
        int position = this.position;
        Optional<N> optionalNode = supplier.get();
        if (!optionalNode.isPresent()) {
            this.position = position;
        }
        return optionalNode;
    }

    public boolean isEndOfLine() {
        if (!this.hasCode()) {
            return true;
        }
        while (Character.isWhitespace(this.currentChar()) && this.currentChar() != '\n') {
            this.popChar();
        }
        return this.currentChar() == '\n';
    }

    public String codeBefore(Notation notation) {
        int index = this.code.indexOf(notation.getLabel(), this.position);
        return index >= 0 ? this.code.substring(this.position, index) : this.code.substring(this.position);
    }

    public int nextPosition() {
        return this.trimBlankAndComment().position;
    }
}

